/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.migrationhuborchestrator.model.AccessDeniedException;
import software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepGroupResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.InternalServerException;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorException;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ResourceNotFoundException;
import software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StartWorkflowRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StartWorkflowResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StopWorkflowRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StopWorkflowResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TagResourceRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TagResourceResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ThrottlingException;
import software.amazon.awssdk.services.migrationhuborchestrator.model.UntagResourceRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.UntagResourceResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ValidationException;
import software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListPluginsIterable;
import software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepGroupsIterable;
import software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepsIterable;
import software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplatesIterable;
import software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepGroupsIterable;
import software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepsIterable;
import software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowsIterable;

/**
 * Service client for accessing AWS Migration Hub Orchestrator. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * This API reference provides descriptions, syntax, and other details about each of the actions and data types for AWS
 * Migration Hub Orchestrator. he topic for each action shows the API request parameters and the response.
 * Alternatively, you can use one of the AWS SDKs to access an API that is tailored to the programming language or
 * platform that you're using.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MigrationHubOrchestratorClient extends AwsClient {
    String SERVICE_NAME = "migrationhub-orchestrator";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "migrationhub-orchestrator";

    /**
     * <p>
     * Create a workflow to orchestrate your migrations.
     * </p>
     *
     * @param createWorkflowRequest
     * @return Result of the CreateWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkflowResponse createWorkflow(CreateWorkflowRequest createWorkflowRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a workflow to orchestrate your migrations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkflowRequest#builder()}
     * </p>
     *
     * @param createWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link CreateMigrationWorkflowRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkflowResponse createWorkflow(Consumer<CreateWorkflowRequest.Builder> createWorkflowRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return createWorkflow(CreateWorkflowRequest.builder().applyMutation(createWorkflowRequest).build());
    }

    /**
     * <p>
     * Create a step in the migration workflow.
     * </p>
     *
     * @param createWorkflowStepRequest
     * @return Result of the CreateWorkflowStep operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.CreateWorkflowStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateWorkflowStep"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkflowStepResponse createWorkflowStep(CreateWorkflowStepRequest createWorkflowStepRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a step in the migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkflowStepRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkflowStepRequest#builder()}
     * </p>
     *
     * @param createWorkflowStepRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkflowStepRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWorkflowStep operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.CreateWorkflowStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateWorkflowStep"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkflowStepResponse createWorkflowStep(Consumer<CreateWorkflowStepRequest.Builder> createWorkflowStepRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return createWorkflowStep(CreateWorkflowStepRequest.builder().applyMutation(createWorkflowStepRequest).build());
    }

    /**
     * <p>
     * Create a step group in a migration workflow.
     * </p>
     *
     * @param createWorkflowStepGroupRequest
     * @return Result of the CreateWorkflowStepGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.CreateWorkflowStepGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateWorkflowStepGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkflowStepGroupResponse createWorkflowStepGroup(CreateWorkflowStepGroupRequest createWorkflowStepGroupRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a step group in a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkflowStepGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateWorkflowStepGroupRequest#builder()}
     * </p>
     *
     * @param createWorkflowStepGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkflowStepGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWorkflowStepGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.CreateWorkflowStepGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateWorkflowStepGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkflowStepGroupResponse createWorkflowStepGroup(
            Consumer<CreateWorkflowStepGroupRequest.Builder> createWorkflowStepGroupRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return createWorkflowStepGroup(CreateWorkflowStepGroupRequest.builder().applyMutation(createWorkflowStepGroupRequest)
                .build());
    }

    /**
     * <p>
     * Delete a migration workflow. You must pause a running workflow in Migration Hub Orchestrator console to delete
     * it.
     * </p>
     *
     * @param deleteWorkflowRequest
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkflowResponse deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a migration workflow. You must pause a running workflow in Migration Hub Orchestrator console to delete
     * it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMigrationWorkflowRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkflowResponse deleteWorkflow(Consumer<DeleteWorkflowRequest.Builder> deleteWorkflowRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return deleteWorkflow(DeleteWorkflowRequest.builder().applyMutation(deleteWorkflowRequest).build());
    }

    /**
     * <p>
     * Delete a step in a migration workflow. Pause the workflow to delete a running step.
     * </p>
     *
     * @param deleteWorkflowStepRequest
     * @return Result of the DeleteWorkflowStep operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.DeleteWorkflowStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteWorkflowStep"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkflowStepResponse deleteWorkflowStep(DeleteWorkflowStepRequest deleteWorkflowStepRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a step in a migration workflow. Pause the workflow to delete a running step.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowStepRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkflowStepRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowStepRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkflowStepRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWorkflowStep operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.DeleteWorkflowStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteWorkflowStep"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkflowStepResponse deleteWorkflowStep(Consumer<DeleteWorkflowStepRequest.Builder> deleteWorkflowStepRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return deleteWorkflowStep(DeleteWorkflowStepRequest.builder().applyMutation(deleteWorkflowStepRequest).build());
    }

    /**
     * <p>
     * Delete a step group in a migration workflow.
     * </p>
     *
     * @param deleteWorkflowStepGroupRequest
     * @return Result of the DeleteWorkflowStepGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.DeleteWorkflowStepGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteWorkflowStepGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkflowStepGroupResponse deleteWorkflowStepGroup(DeleteWorkflowStepGroupRequest deleteWorkflowStepGroupRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a step group in a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowStepGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteWorkflowStepGroupRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowStepGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkflowStepGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWorkflowStepGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.DeleteWorkflowStepGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteWorkflowStepGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkflowStepGroupResponse deleteWorkflowStepGroup(
            Consumer<DeleteWorkflowStepGroupRequest.Builder> deleteWorkflowStepGroupRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return deleteWorkflowStepGroup(DeleteWorkflowStepGroupRequest.builder().applyMutation(deleteWorkflowStepGroupRequest)
                .build());
    }

    /**
     * <p>
     * Get the template you want to use for creating a migration workflow.
     * </p>
     *
     * @param getTemplateRequest
     * @return Result of the GetTemplate operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.GetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTemplateResponse getTemplate(GetTemplateRequest getTemplateRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the template you want to use for creating a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link GetTemplateRequest#builder()}
     * </p>
     *
     * @param getTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetMigrationWorkflowTemplateRequest.Builder} to create
     *        a request.
     * @return Result of the GetTemplate operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.GetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTemplateResponse getTemplate(Consumer<GetTemplateRequest.Builder> getTemplateRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return getTemplate(GetTemplateRequest.builder().applyMutation(getTemplateRequest).build());
    }

    /**
     * <p>
     * Get a specific step in a template.
     * </p>
     *
     * @param getTemplateStepRequest
     * @return Result of the GetTemplateStep operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.GetTemplateStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetTemplateStep"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTemplateStepResponse getTemplateStep(GetTemplateStepRequest getTemplateStepRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a specific step in a template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateStepRequest.Builder} avoiding the need
     * to create one manually via {@link GetTemplateStepRequest#builder()}
     * </p>
     *
     * @param getTemplateStepRequest
     *        A {@link Consumer} that will call methods on {@link GetTemplateStepRequest.Builder} to create a request.
     * @return Result of the GetTemplateStep operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.GetTemplateStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetTemplateStep"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTemplateStepResponse getTemplateStep(Consumer<GetTemplateStepRequest.Builder> getTemplateStepRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return getTemplateStep(GetTemplateStepRequest.builder().applyMutation(getTemplateStepRequest).build());
    }

    /**
     * <p>
     * Get a step group in a template.
     * </p>
     *
     * @param getTemplateStepGroupRequest
     * @return Result of the GetTemplateStepGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.GetTemplateStepGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetTemplateStepGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTemplateStepGroupResponse getTemplateStepGroup(GetTemplateStepGroupRequest getTemplateStepGroupRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a step group in a template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateStepGroupRequest.Builder} avoiding the
     * need to create one manually via {@link GetTemplateStepGroupRequest#builder()}
     * </p>
     *
     * @param getTemplateStepGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetTemplateStepGroupRequest.Builder} to create a
     *        request.
     * @return Result of the GetTemplateStepGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.GetTemplateStepGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetTemplateStepGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTemplateStepGroupResponse getTemplateStepGroup(
            Consumer<GetTemplateStepGroupRequest.Builder> getTemplateStepGroupRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return getTemplateStepGroup(GetTemplateStepGroupRequest.builder().applyMutation(getTemplateStepGroupRequest).build());
    }

    /**
     * <p>
     * Get migration workflow.
     * </p>
     *
     * @param getWorkflowRequest
     * @return Result of the GetWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowResponse getWorkflow(GetWorkflowRequest getWorkflowRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkflowRequest#builder()}
     * </p>
     *
     * @param getWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link GetMigrationWorkflowRequest.Builder} to create a
     *        request.
     * @return Result of the GetWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowResponse getWorkflow(Consumer<GetWorkflowRequest.Builder> getWorkflowRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return getWorkflow(GetWorkflowRequest.builder().applyMutation(getWorkflowRequest).build());
    }

    /**
     * <p>
     * Get a step in the migration workflow.
     * </p>
     *
     * @param getWorkflowStepRequest
     * @return Result of the GetWorkflowStep operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.GetWorkflowStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetWorkflowStep"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowStepResponse getWorkflowStep(GetWorkflowStepRequest getWorkflowStepRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a step in the migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowStepRequest.Builder} avoiding the need
     * to create one manually via {@link GetWorkflowStepRequest#builder()}
     * </p>
     *
     * @param getWorkflowStepRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowStepRequest.Builder} to create a request.
     * @return Result of the GetWorkflowStep operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.GetWorkflowStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetWorkflowStep"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowStepResponse getWorkflowStep(Consumer<GetWorkflowStepRequest.Builder> getWorkflowStepRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return getWorkflowStep(GetWorkflowStepRequest.builder().applyMutation(getWorkflowStepRequest).build());
    }

    /**
     * <p>
     * Get the step group of a migration workflow.
     * </p>
     *
     * @param getWorkflowStepGroupRequest
     * @return Result of the GetWorkflowStepGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.GetWorkflowStepGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetWorkflowStepGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowStepGroupResponse getWorkflowStepGroup(GetWorkflowStepGroupRequest getWorkflowStepGroupRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the step group of a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowStepGroupRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkflowStepGroupRequest#builder()}
     * </p>
     *
     * @param getWorkflowStepGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowStepGroupRequest.Builder} to create a
     *        request.
     * @return Result of the GetWorkflowStepGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.GetWorkflowStepGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetWorkflowStepGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowStepGroupResponse getWorkflowStepGroup(
            Consumer<GetWorkflowStepGroupRequest.Builder> getWorkflowStepGroupRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return getWorkflowStepGroup(GetWorkflowStepGroupRequest.builder().applyMutation(getWorkflowStepGroupRequest).build());
    }

    /**
     * <p>
     * List AWS Migration Hub Orchestrator plugins.
     * </p>
     *
     * @param listPluginsRequest
     * @return Result of the ListPlugins operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListPlugins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPluginsResponse listPlugins(ListPluginsRequest listPluginsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List AWS Migration Hub Orchestrator plugins.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPluginsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPluginsRequest#builder()}
     * </p>
     *
     * @param listPluginsRequest
     *        A {@link Consumer} that will call methods on {@link ListPluginsRequest.Builder} to create a request.
     * @return Result of the ListPlugins operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListPlugins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPluginsResponse listPlugins(Consumer<ListPluginsRequest.Builder> listPluginsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return listPlugins(ListPluginsRequest.builder().applyMutation(listPluginsRequest).build());
    }

    /**
     * <p>
     * List AWS Migration Hub Orchestrator plugins.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlugins(software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListPluginsIterable responses = client.listPluginsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListPluginsIterable responses = client
     *             .listPluginsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListPluginsIterable responses = client.listPluginsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlugins(software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPluginsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListPlugins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPluginsIterable listPluginsPaginator(ListPluginsRequest listPluginsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return new ListPluginsIterable(this, listPluginsRequest);
    }

    /**
     * <p>
     * List AWS Migration Hub Orchestrator plugins.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlugins(software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListPluginsIterable responses = client.listPluginsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListPluginsIterable responses = client
     *             .listPluginsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListPluginsIterable responses = client.listPluginsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlugins(software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPluginsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPluginsRequest#builder()}
     * </p>
     *
     * @param listPluginsRequest
     *        A {@link Consumer} that will call methods on {@link ListPluginsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListPlugins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPluginsIterable listPluginsPaginator(Consumer<ListPluginsRequest.Builder> listPluginsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return listPluginsPaginator(ListPluginsRequest.builder().applyMutation(listPluginsRequest).build());
    }

    /**
     * <p>
     * List the tags added to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags added to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List the step groups in a template.
     * </p>
     *
     * @param listTemplateStepGroupsRequest
     * @return Result of the ListTemplateStepGroups operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTemplateStepGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplateStepGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateStepGroupsResponse listTemplateStepGroups(ListTemplateStepGroupsRequest listTemplateStepGroupsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the step groups in a template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateStepGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateStepGroupsRequest#builder()}
     * </p>
     *
     * @param listTemplateStepGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateStepGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTemplateStepGroups operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTemplateStepGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplateStepGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateStepGroupsResponse listTemplateStepGroups(
            Consumer<ListTemplateStepGroupsRequest.Builder> listTemplateStepGroupsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return listTemplateStepGroups(ListTemplateStepGroupsRequest.builder().applyMutation(listTemplateStepGroupsRequest)
                .build());
    }

    /**
     * <p>
     * List the step groups in a template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateStepGroups(software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepGroupsIterable responses = client.listTemplateStepGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepGroupsIterable responses = client
     *             .listTemplateStepGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepGroupsIterable responses = client.listTemplateStepGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateStepGroups(software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplateStepGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTemplateStepGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplateStepGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateStepGroupsIterable listTemplateStepGroupsPaginator(
            ListTemplateStepGroupsRequest listTemplateStepGroupsRequest) throws ThrottlingException, AccessDeniedException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return new ListTemplateStepGroupsIterable(this, listTemplateStepGroupsRequest);
    }

    /**
     * <p>
     * List the step groups in a template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateStepGroups(software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepGroupsIterable responses = client.listTemplateStepGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepGroupsIterable responses = client
     *             .listTemplateStepGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepGroupsIterable responses = client.listTemplateStepGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateStepGroups(software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateStepGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateStepGroupsRequest#builder()}
     * </p>
     *
     * @param listTemplateStepGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateStepGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTemplateStepGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplateStepGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateStepGroupsIterable listTemplateStepGroupsPaginator(
            Consumer<ListTemplateStepGroupsRequest.Builder> listTemplateStepGroupsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return listTemplateStepGroupsPaginator(ListTemplateStepGroupsRequest.builder()
                .applyMutation(listTemplateStepGroupsRequest).build());
    }

    /**
     * <p>
     * List the steps in a template.
     * </p>
     *
     * @param listTemplateStepsRequest
     * @return Result of the ListTemplateSteps operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTemplateSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplateSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateStepsResponse listTemplateSteps(ListTemplateStepsRequest listTemplateStepsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the steps in a template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateStepsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTemplateStepsRequest#builder()}
     * </p>
     *
     * @param listTemplateStepsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateStepsRequest.Builder} to create a request.
     * @return Result of the ListTemplateSteps operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTemplateSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplateSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateStepsResponse listTemplateSteps(Consumer<ListTemplateStepsRequest.Builder> listTemplateStepsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return listTemplateSteps(ListTemplateStepsRequest.builder().applyMutation(listTemplateStepsRequest).build());
    }

    /**
     * <p>
     * List the steps in a template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateSteps(software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepsIterable responses = client.listTemplateStepsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepsIterable responses = client
     *             .listTemplateStepsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepsIterable responses = client.listTemplateStepsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateSteps(software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplateStepsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTemplateSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplateSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateStepsIterable listTemplateStepsPaginator(ListTemplateStepsRequest listTemplateStepsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return new ListTemplateStepsIterable(this, listTemplateStepsRequest);
    }

    /**
     * <p>
     * List the steps in a template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateSteps(software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepsIterable responses = client.listTemplateStepsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepsIterable responses = client
     *             .listTemplateStepsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplateStepsIterable responses = client.listTemplateStepsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateSteps(software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateStepsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTemplateStepsRequest#builder()}
     * </p>
     *
     * @param listTemplateStepsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateStepsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTemplateSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplateSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateStepsIterable listTemplateStepsPaginator(
            Consumer<ListTemplateStepsRequest.Builder> listTemplateStepsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return listTemplateStepsPaginator(ListTemplateStepsRequest.builder().applyMutation(listTemplateStepsRequest).build());
    }

    /**
     * <p>
     * List the templates available in Migration Hub Orchestrator to create a migration workflow.
     * </p>
     *
     * @param listTemplatesRequest
     * @return Result of the ListTemplates operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplatesResponse listTemplates(ListTemplatesRequest listTemplatesRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the templates available in Migration Hub Orchestrator to create a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListMigrationWorkflowTemplatesRequest.Builder} to
     *        create a request.
     * @return Result of the ListTemplates operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplatesResponse listTemplates(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return listTemplates(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * List the templates available in Migration Hub Orchestrator to create a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplates(software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplatesIterable responses = client
     *             .listTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplates(software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplatesIterable listTemplatesPaginator(ListTemplatesRequest listTemplatesRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return new ListTemplatesIterable(this, listTemplatesRequest);
    }

    /**
     * <p>
     * List the templates available in Migration Hub Orchestrator to create a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplates(software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplatesIterable responses = client
     *             .listTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplates(software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListMigrationWorkflowTemplatesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplatesIterable listTemplatesPaginator(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return listTemplatesPaginator(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * List the step groups in a migration workflow.
     * </p>
     *
     * @param listWorkflowStepGroupsRequest
     * @return Result of the ListWorkflowStepGroups operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListWorkflowStepGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflowStepGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowStepGroupsResponse listWorkflowStepGroups(ListWorkflowStepGroupsRequest listWorkflowStepGroupsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the step groups in a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowStepGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkflowStepGroupsRequest#builder()}
     * </p>
     *
     * @param listWorkflowStepGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowStepGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListWorkflowStepGroups operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListWorkflowStepGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflowStepGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowStepGroupsResponse listWorkflowStepGroups(
            Consumer<ListWorkflowStepGroupsRequest.Builder> listWorkflowStepGroupsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return listWorkflowStepGroups(ListWorkflowStepGroupsRequest.builder().applyMutation(listWorkflowStepGroupsRequest)
                .build());
    }

    /**
     * <p>
     * List the step groups in a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkflowStepGroups(software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepGroupsIterable responses = client.listWorkflowStepGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepGroupsIterable responses = client
     *             .listWorkflowStepGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepGroupsIterable responses = client.listWorkflowStepGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowStepGroups(software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkflowStepGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListWorkflowStepGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflowStepGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowStepGroupsIterable listWorkflowStepGroupsPaginator(
            ListWorkflowStepGroupsRequest listWorkflowStepGroupsRequest) throws ThrottlingException, AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return new ListWorkflowStepGroupsIterable(this, listWorkflowStepGroupsRequest);
    }

    /**
     * <p>
     * List the step groups in a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkflowStepGroups(software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepGroupsIterable responses = client.listWorkflowStepGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepGroupsIterable responses = client
     *             .listWorkflowStepGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepGroupsIterable responses = client.listWorkflowStepGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowStepGroups(software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowStepGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkflowStepGroupsRequest#builder()}
     * </p>
     *
     * @param listWorkflowStepGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowStepGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListWorkflowStepGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflowStepGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowStepGroupsIterable listWorkflowStepGroupsPaginator(
            Consumer<ListWorkflowStepGroupsRequest.Builder> listWorkflowStepGroupsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return listWorkflowStepGroupsPaginator(ListWorkflowStepGroupsRequest.builder()
                .applyMutation(listWorkflowStepGroupsRequest).build());
    }

    /**
     * <p>
     * List the steps in a workflow.
     * </p>
     *
     * @param listWorkflowStepsRequest
     * @return Result of the ListWorkflowSteps operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListWorkflowSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowStepsResponse listWorkflowSteps(ListWorkflowStepsRequest listWorkflowStepsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the steps in a workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowStepsRequest.Builder} avoiding the need
     * to create one manually via {@link ListWorkflowStepsRequest#builder()}
     * </p>
     *
     * @param listWorkflowStepsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowStepsRequest.Builder} to create a request.
     * @return Result of the ListWorkflowSteps operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListWorkflowSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowStepsResponse listWorkflowSteps(Consumer<ListWorkflowStepsRequest.Builder> listWorkflowStepsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return listWorkflowSteps(ListWorkflowStepsRequest.builder().applyMutation(listWorkflowStepsRequest).build());
    }

    /**
     * <p>
     * List the steps in a workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkflowSteps(software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepsIterable responses = client.listWorkflowStepsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepsIterable responses = client
     *             .listWorkflowStepsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepsIterable responses = client.listWorkflowStepsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowSteps(software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkflowStepsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListWorkflowSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowStepsIterable listWorkflowStepsPaginator(ListWorkflowStepsRequest listWorkflowStepsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return new ListWorkflowStepsIterable(this, listWorkflowStepsRequest);
    }

    /**
     * <p>
     * List the steps in a workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkflowSteps(software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepsIterable responses = client.listWorkflowStepsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepsIterable responses = client
     *             .listWorkflowStepsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowStepsIterable responses = client.listWorkflowStepsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowSteps(software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowStepsRequest.Builder} avoiding the need
     * to create one manually via {@link ListWorkflowStepsRequest#builder()}
     * </p>
     *
     * @param listWorkflowStepsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowStepsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListWorkflowSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowStepsIterable listWorkflowStepsPaginator(
            Consumer<ListWorkflowStepsRequest.Builder> listWorkflowStepsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return listWorkflowStepsPaginator(ListWorkflowStepsRequest.builder().applyMutation(listWorkflowStepsRequest).build());
    }

    /**
     * <p>
     * List the migration workflows.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowsResponse listWorkflows(ListWorkflowsRequest listWorkflowsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the migration workflows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on {@link ListMigrationWorkflowsRequest.Builder} to create a
     *        request.
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowsResponse listWorkflows(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return listWorkflows(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * List the migration workflows.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkflows(software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowsIterable responses = client
     *             .listWorkflowsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowsIterable listWorkflowsPaginator(ListWorkflowsRequest listWorkflowsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return new ListWorkflowsIterable(this, listWorkflowsRequest);
    }

    /**
     * <p>
     * List the migration workflows.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkflows(software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowsIterable responses = client
     *             .listWorkflowsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhuborchestrator.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on {@link ListMigrationWorkflowsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowsIterable listWorkflowsPaginator(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return listWorkflowsPaginator(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * Retry a failed step in a migration workflow.
     * </p>
     *
     * @param retryWorkflowStepRequest
     * @return Result of the RetryWorkflowStep operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.RetryWorkflowStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/RetryWorkflowStep"
     *      target="_top">AWS API Documentation</a>
     */
    default RetryWorkflowStepResponse retryWorkflowStep(RetryWorkflowStepRequest retryWorkflowStepRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retry a failed step in a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetryWorkflowStepRequest.Builder} avoiding the need
     * to create one manually via {@link RetryWorkflowStepRequest#builder()}
     * </p>
     *
     * @param retryWorkflowStepRequest
     *        A {@link Consumer} that will call methods on {@link RetryWorkflowStepRequest.Builder} to create a request.
     * @return Result of the RetryWorkflowStep operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.RetryWorkflowStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/RetryWorkflowStep"
     *      target="_top">AWS API Documentation</a>
     */
    default RetryWorkflowStepResponse retryWorkflowStep(Consumer<RetryWorkflowStepRequest.Builder> retryWorkflowStepRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return retryWorkflowStep(RetryWorkflowStepRequest.builder().applyMutation(retryWorkflowStepRequest).build());
    }

    /**
     * <p>
     * Start a migration workflow.
     * </p>
     *
     * @param startWorkflowRequest
     * @return Result of the StartWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.StartWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/StartWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default StartWorkflowResponse startWorkflow(StartWorkflowRequest startWorkflowRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link StartWorkflowRequest#builder()}
     * </p>
     *
     * @param startWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link StartMigrationWorkflowRequest.Builder} to create a
     *        request.
     * @return Result of the StartWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.StartWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/StartWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default StartWorkflowResponse startWorkflow(Consumer<StartWorkflowRequest.Builder> startWorkflowRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return startWorkflow(StartWorkflowRequest.builder().applyMutation(startWorkflowRequest).build());
    }

    /**
     * <p>
     * Stop an ongoing migration workflow.
     * </p>
     *
     * @param stopWorkflowRequest
     * @return Result of the StopWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.StopWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/StopWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default StopWorkflowResponse stopWorkflow(StopWorkflowRequest stopWorkflowRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop an ongoing migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link StopWorkflowRequest#builder()}
     * </p>
     *
     * @param stopWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link StopMigrationWorkflowRequest.Builder} to create a
     *        request.
     * @return Result of the StopWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.StopWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/StopWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default StopWorkflowResponse stopWorkflow(Consumer<StopWorkflowRequest.Builder> stopWorkflowRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return stopWorkflow(StopWorkflowRequest.builder().applyMutation(stopWorkflowRequest).build());
    }

    /**
     * <p>
     * Tag a resource by specifying its Amazon Resource Name (ARN).
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tag a resource by specifying its Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes the tags for a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MigrationHubOrchestratorException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update a migration workflow.
     * </p>
     *
     * @param updateWorkflowRequest
     * @return Result of the UpdateWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.UpdateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkflowResponse updateWorkflow(UpdateWorkflowRequest updateWorkflowRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWorkflowRequest#builder()}
     * </p>
     *
     * @param updateWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMigrationWorkflowRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.UpdateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkflowResponse updateWorkflow(Consumer<UpdateWorkflowRequest.Builder> updateWorkflowRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        return updateWorkflow(UpdateWorkflowRequest.builder().applyMutation(updateWorkflowRequest).build());
    }

    /**
     * <p>
     * Update a step in a migration workflow.
     * </p>
     *
     * @param updateWorkflowStepRequest
     * @return Result of the UpdateWorkflowStep operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.UpdateWorkflowStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateWorkflowStep"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkflowStepResponse updateWorkflowStep(UpdateWorkflowStepRequest updateWorkflowStepRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a step in a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkflowStepRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkflowStepRequest#builder()}
     * </p>
     *
     * @param updateWorkflowStepRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorkflowStepRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateWorkflowStep operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.UpdateWorkflowStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateWorkflowStep"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkflowStepResponse updateWorkflowStep(Consumer<UpdateWorkflowStepRequest.Builder> updateWorkflowStepRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return updateWorkflowStep(UpdateWorkflowStepRequest.builder().applyMutation(updateWorkflowStepRequest).build());
    }

    /**
     * <p>
     * Update the step group in a migration workflow.
     * </p>
     *
     * @param updateWorkflowStepGroupRequest
     * @return Result of the UpdateWorkflowStepGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.UpdateWorkflowStepGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateWorkflowStepGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkflowStepGroupResponse updateWorkflowStepGroup(UpdateWorkflowStepGroupRequest updateWorkflowStepGroupRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MigrationHubOrchestratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the step group in a migration workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkflowStepGroupRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateWorkflowStepGroupRequest#builder()}
     * </p>
     *
     * @param updateWorkflowStepGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorkflowStepGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateWorkflowStepGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubOrchestratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubOrchestratorClient.UpdateWorkflowStepGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateWorkflowStepGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkflowStepGroupResponse updateWorkflowStepGroup(
            Consumer<UpdateWorkflowStepGroupRequest.Builder> updateWorkflowStepGroupRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, MigrationHubOrchestratorException {
        return updateWorkflowStepGroup(UpdateWorkflowStepGroupRequest.builder().applyMutation(updateWorkflowStepGroupRequest)
                .build());
    }

    /**
     * Create a {@link MigrationHubOrchestratorClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MigrationHubOrchestratorClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MigrationHubOrchestratorClient}.
     */
    static MigrationHubOrchestratorClientBuilder builder() {
        return new DefaultMigrationHubOrchestratorClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MigrationHubOrchestratorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
