/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorClient;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummary;

public class ListTemplateStepGroupsIterable
implements SdkIterable<ListTemplateStepGroupsResponse> {
    private final MigrationHubOrchestratorClient client;
    private final ListTemplateStepGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTemplateStepGroupsIterable(MigrationHubOrchestratorClient client, ListTemplateStepGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTemplateStepGroupsResponseFetcher();
    }

    public Iterator<ListTemplateStepGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TemplateStepGroupSummary> templateStepGroupSummary() {
        Function<ListTemplateStepGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateStepGroupSummary() != null) {
                return response.templateStepGroupSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTemplateStepGroupsResponseFetcher
    implements SyncPageFetcher<ListTemplateStepGroupsResponse> {
        private ListTemplateStepGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateStepGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTemplateStepGroupsResponse nextPage(ListTemplateStepGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateStepGroupsIterable.this.client.listTemplateStepGroups(ListTemplateStepGroupsIterable.this.firstRequest);
            }
            return ListTemplateStepGroupsIterable.this.client.listTemplateStepGroups((ListTemplateStepGroupsRequest)((Object)ListTemplateStepGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

