/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepGroupSummary;
import software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepGroupsSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkflowStepGroupsResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, ListWorkflowStepGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkflowStepGroupsResponse.getter(ListWorkflowStepGroupsResponse::nextToken)).setter(ListWorkflowStepGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<WorkflowStepGroupSummary>> WORKFLOW_STEP_GROUPS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workflowStepGroupsSummary").getter(ListWorkflowStepGroupsResponse.getter(ListWorkflowStepGroupsResponse::workflowStepGroupsSummary)).setter(ListWorkflowStepGroupsResponse.setter(Builder::workflowStepGroupsSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowStepGroupsSummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowStepGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WORKFLOW_STEP_GROUPS_SUMMARY_FIELD));
    private final String nextToken;
    private final List<WorkflowStepGroupSummary> workflowStepGroupsSummary;

    private ListWorkflowStepGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workflowStepGroupsSummary = builder.workflowStepGroupsSummary;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWorkflowStepGroupsSummary() {
        return this.workflowStepGroupsSummary != null && !(this.workflowStepGroupsSummary instanceof SdkAutoConstructList);
    }

    public final List<WorkflowStepGroupSummary> workflowStepGroupsSummary() {
        return this.workflowStepGroupsSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflowStepGroupsSummary() ? this.workflowStepGroupsSummary() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowStepGroupsResponse)) {
            return false;
        }
        ListWorkflowStepGroupsResponse other = (ListWorkflowStepGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWorkflowStepGroupsSummary() == other.hasWorkflowStepGroupsSummary() && Objects.equals(this.workflowStepGroupsSummary(), other.workflowStepGroupsSummary());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkflowStepGroupsResponse").add("NextToken", (Object)this.nextToken()).add("WorkflowStepGroupsSummary", this.hasWorkflowStepGroupsSummary() ? this.workflowStepGroupsSummary() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "workflowStepGroupsSummary": {
                return Optional.ofNullable(clazz.cast(this.workflowStepGroupsSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowStepGroupsResponse, T> g) {
        return obj -> g.apply((ListWorkflowStepGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WorkflowStepGroupSummary> workflowStepGroupsSummary = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowStepGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.workflowStepGroupsSummary(model.workflowStepGroupsSummary);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkflowStepGroupSummary.Builder> getWorkflowStepGroupsSummary() {
            List<WorkflowStepGroupSummary.Builder> result = WorkflowStepGroupsSummaryListCopier.copyToBuilder(this.workflowStepGroupsSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflowStepGroupsSummary(Collection<WorkflowStepGroupSummary.BuilderImpl> workflowStepGroupsSummary) {
            this.workflowStepGroupsSummary = WorkflowStepGroupsSummaryListCopier.copyFromBuilder(workflowStepGroupsSummary);
        }

        @Override
        public final Builder workflowStepGroupsSummary(Collection<WorkflowStepGroupSummary> workflowStepGroupsSummary) {
            this.workflowStepGroupsSummary = WorkflowStepGroupsSummaryListCopier.copy(workflowStepGroupsSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowStepGroupsSummary(WorkflowStepGroupSummary ... workflowStepGroupsSummary) {
            this.workflowStepGroupsSummary(Arrays.asList(workflowStepGroupsSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowStepGroupsSummary(Consumer<WorkflowStepGroupSummary.Builder> ... workflowStepGroupsSummary) {
            this.workflowStepGroupsSummary(Stream.of(workflowStepGroupsSummary).map(c -> (WorkflowStepGroupSummary)((WorkflowStepGroupSummary.Builder)WorkflowStepGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkflowStepGroupsResponse build() {
            return new ListWorkflowStepGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkflowStepGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder workflowStepGroupsSummary(Collection<WorkflowStepGroupSummary> var1);

        public Builder workflowStepGroupsSummary(WorkflowStepGroupSummary ... var1);

        public Builder workflowStepGroupsSummary(Consumer<WorkflowStepGroupSummary.Builder> ... var1);
    }
}

