/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubconfig;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.migrationhubconfig.DefaultMigrationHubConfigAsyncClient;
import software.amazon.awssdk.services.migrationhubconfig.DefaultMigrationHubConfigBaseClientBuilder;
import software.amazon.awssdk.services.migrationhubconfig.MigrationHubConfigAsyncClient;
import software.amazon.awssdk.services.migrationhubconfig.MigrationHubConfigAsyncClientBuilder;
import software.amazon.awssdk.services.migrationhubconfig.MigrationHubConfigServiceClientConfiguration;
import software.amazon.awssdk.services.migrationhubconfig.endpoints.MigrationHubConfigEndpointProvider;

@SdkInternalApi
final class DefaultMigrationHubConfigAsyncClientBuilder
extends DefaultMigrationHubConfigBaseClientBuilder<MigrationHubConfigAsyncClientBuilder, MigrationHubConfigAsyncClient>
implements MigrationHubConfigAsyncClientBuilder {
    DefaultMigrationHubConfigAsyncClientBuilder() {
    }

    @Override
    public DefaultMigrationHubConfigAsyncClientBuilder endpointProvider(MigrationHubConfigEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MigrationHubConfigAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMigrationHubConfigAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MigrationHubConfigServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMigrationHubConfigAsyncClient client = new DefaultMigrationHubConfigAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MigrationHubConfigServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MigrationHubConfigServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

