/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpdateType {
    MIGRATION_TASK_STATE_UPDATED("MIGRATION_TASK_STATE_UPDATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpdateType> VALUE_MAP;
    private final String value;

    private UpdateType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpdateType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpdateType> knownValues() {
        EnumSet<UpdateType> knownValues = EnumSet.allOf(UpdateType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpdateType.class, UpdateType::toString);
    }
}

