/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubResponse;
import software.amazon.awssdk.services.migrationhub.model.SourceResource;
import software.amazon.awssdk.services.migrationhub.model.SourceResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSourceResourcesResponse
extends MigrationHubResponse
implements ToCopyableBuilder<Builder, ListSourceResourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSourceResourcesResponse.getter(ListSourceResourcesResponse::nextToken)).setter(ListSourceResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SourceResource>> SOURCE_RESOURCE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceResourceList").getter(ListSourceResourcesResponse.getter(ListSourceResourcesResponse::sourceResourceList)).setter(ListSourceResourcesResponse.setter(Builder::sourceResourceList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SOURCE_RESOURCE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("SourceResourceList", SOURCE_RESOURCE_LIST_FIELD);
        }
    });
    private final String nextToken;
    private final List<SourceResource> sourceResourceList;

    private ListSourceResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sourceResourceList = builder.sourceResourceList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSourceResourceList() {
        return this.sourceResourceList != null && !(this.sourceResourceList instanceof SdkAutoConstructList);
    }

    public final List<SourceResource> sourceResourceList() {
        return this.sourceResourceList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceResourceList() ? this.sourceResourceList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSourceResourcesResponse)) {
            return false;
        }
        ListSourceResourcesResponse other = (ListSourceResourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSourceResourceList() == other.hasSourceResourceList() && Objects.equals(this.sourceResourceList(), other.sourceResourceList());
    }

    public final String toString() {
        return ToString.builder((String)"ListSourceResourcesResponse").add("NextToken", (Object)this.nextToken()).add("SourceResourceList", this.hasSourceResourceList() ? this.sourceResourceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SourceResourceList": {
                return Optional.ofNullable(clazz.cast(this.sourceResourceList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSourceResourcesResponse, T> g) {
        return obj -> g.apply((ListSourceResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SourceResource> sourceResourceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSourceResourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.sourceResourceList(model.sourceResourceList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SourceResource.Builder> getSourceResourceList() {
            List<SourceResource.Builder> result = SourceResourceListCopier.copyToBuilder(this.sourceResourceList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceResourceList(Collection<SourceResource.BuilderImpl> sourceResourceList) {
            this.sourceResourceList = SourceResourceListCopier.copyFromBuilder(sourceResourceList);
        }

        @Override
        public final Builder sourceResourceList(Collection<SourceResource> sourceResourceList) {
            this.sourceResourceList = SourceResourceListCopier.copy(sourceResourceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceResourceList(SourceResource ... sourceResourceList) {
            this.sourceResourceList(Arrays.asList(sourceResourceList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceResourceList(Consumer<SourceResource.Builder> ... sourceResourceList) {
            this.sourceResourceList(Stream.of(sourceResourceList).map(c -> (SourceResource)((SourceResource.Builder)SourceResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSourceResourcesResponse build() {
            return new ListSourceResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSourceResourcesResponse> {
        public Builder nextToken(String var1);

        public Builder sourceResourceList(Collection<SourceResource> var1);

        public Builder sourceResourceList(SourceResource ... var1);

        public Builder sourceResourceList(Consumer<SourceResource.Builder> ... var1);
    }
}

