/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubResponse;
import software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary;
import software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMigrationTasksResponse
extends MigrationHubResponse
implements ToCopyableBuilder<Builder, ListMigrationTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMigrationTasksResponse.getter(ListMigrationTasksResponse::nextToken)).setter(ListMigrationTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<MigrationTaskSummary>> MIGRATION_TASK_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListMigrationTasksResponse.getter(ListMigrationTasksResponse::migrationTaskSummaryList)).setter(ListMigrationTasksResponse.setter(Builder::migrationTaskSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MigrationTaskSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MIGRATION_TASK_SUMMARY_LIST_FIELD));
    private final String nextToken;
    private final List<MigrationTaskSummary> migrationTaskSummaryList;

    private ListMigrationTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.migrationTaskSummaryList = builder.migrationTaskSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasMigrationTaskSummaryList() {
        return this.migrationTaskSummaryList != null && !(this.migrationTaskSummaryList instanceof SdkAutoConstructList);
    }

    public List<MigrationTaskSummary> migrationTaskSummaryList() {
        return this.migrationTaskSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTaskSummaryList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMigrationTasksResponse)) {
            return false;
        }
        ListMigrationTasksResponse other = (ListMigrationTasksResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.migrationTaskSummaryList(), other.migrationTaskSummaryList());
    }

    public String toString() {
        return ToString.builder((String)"ListMigrationTasksResponse").add("NextToken", (Object)this.nextToken()).add("MigrationTaskSummaryList", this.migrationTaskSummaryList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MigrationTaskSummaryList": {
                return Optional.ofNullable(clazz.cast(this.migrationTaskSummaryList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMigrationTasksResponse, T> g) {
        return obj -> g.apply((ListMigrationTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MigrationTaskSummary> migrationTaskSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMigrationTasksResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.migrationTaskSummaryList(model.migrationTaskSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<MigrationTaskSummary.Builder> getMigrationTaskSummaryList() {
            return this.migrationTaskSummaryList != null ? (Collection)this.migrationTaskSummaryList.stream().map(MigrationTaskSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder migrationTaskSummaryList(Collection<MigrationTaskSummary> migrationTaskSummaryList) {
            this.migrationTaskSummaryList = MigrationTaskSummaryListCopier.copy(migrationTaskSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationTaskSummaryList(MigrationTaskSummary ... migrationTaskSummaryList) {
            this.migrationTaskSummaryList(Arrays.asList(migrationTaskSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationTaskSummaryList(Consumer<MigrationTaskSummary.Builder> ... migrationTaskSummaryList) {
            this.migrationTaskSummaryList(Stream.of(migrationTaskSummaryList).map(c -> (MigrationTaskSummary)((MigrationTaskSummary.Builder)MigrationTaskSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMigrationTaskSummaryList(Collection<MigrationTaskSummary.BuilderImpl> migrationTaskSummaryList) {
            this.migrationTaskSummaryList = MigrationTaskSummaryListCopier.copyFromBuilder(migrationTaskSummaryList);
        }

        @Override
        public ListMigrationTasksResponse build() {
            return new ListMigrationTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMigrationTasksResponse> {
        public Builder nextToken(String var1);

        public Builder migrationTaskSummaryList(Collection<MigrationTaskSummary> var1);

        public Builder migrationTaskSummaryList(MigrationTaskSummary ... var1);

        public Builder migrationTaskSummaryList(Consumer<MigrationTaskSummary.Builder> ... var1);
    }
}

