/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDiscoveredResourcesRequest extends MigrationHubRequest implements
        ToCopyableBuilder<ListDiscoveredResourcesRequest.Builder, ListDiscoveredResourcesRequest> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDiscoveredResourcesRequest::progressUpdateStream)).setter(setter(Builder::progressUpdateStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build())
            .build();

    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDiscoveredResourcesRequest::migrationTaskName)).setter(setter(Builder::migrationTaskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDiscoveredResourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListDiscoveredResourcesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD,
            MIGRATION_TASK_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String progressUpdateStream;

    private final String migrationTaskName;

    private final String nextToken;

    private final Integer maxResults;

    private ListDiscoveredResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The name of the ProgressUpdateStream.
     * </p>
     * 
     * @return The name of the ProgressUpdateStream.
     */
    public String progressUpdateStream() {
        return progressUpdateStream;
    }

    /**
     * <p>
     * The name of the MigrationTask. <i>Do not store personal data in this field.</i>
     * </p>
     * 
     * @return The name of the MigrationTask. <i>Do not store personal data in this field.</i>
     */
    public String migrationTaskName() {
        return migrationTaskName;
    }

    /**
     * <p>
     * If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the
     * next page of results, make the call again using the returned token in <code>NextToken</code>.
     * </p>
     * 
     * @return If a <code>NextToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>
     *         .
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results returned per page.
     * </p>
     * 
     * @return The maximum number of results returned per page.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesRequest)) {
            return false;
        }
        ListDiscoveredResourcesRequest other = (ListDiscoveredResourcesRequest) obj;
        return Objects.equals(progressUpdateStream(), other.progressUpdateStream())
                && Objects.equals(migrationTaskName(), other.migrationTaskName())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDiscoveredResourcesRequest").add("ProgressUpdateStream", progressUpdateStream())
                .add("MigrationTaskName", migrationTaskName()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressUpdateStream":
            return Optional.ofNullable(clazz.cast(progressUpdateStream()));
        case "MigrationTaskName":
            return Optional.ofNullable(clazz.cast(migrationTaskName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDiscoveredResourcesRequest, T> g) {
        return obj -> g.apply((ListDiscoveredResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDiscoveredResourcesRequest> {
        /**
         * <p>
         * The name of the ProgressUpdateStream.
         * </p>
         * 
         * @param progressUpdateStream
         *        The name of the ProgressUpdateStream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressUpdateStream(String progressUpdateStream);

        /**
         * <p>
         * The name of the MigrationTask. <i>Do not store personal data in this field.</i>
         * </p>
         * 
         * @param migrationTaskName
         *        The name of the MigrationTask. <i>Do not store personal data in this field.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskName(String migrationTaskName);

        /**
         * <p>
         * If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve
         * the next page of results, make the call again using the returned token in <code>NextToken</code>.
         * </p>
         * 
         * @param nextToken
         *        If a <code>NextToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>NextToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results returned per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRequest.BuilderImpl implements Builder {
        private String progressUpdateStream;

        private String migrationTaskName;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoveredResourcesRequest model) {
            super(model);
            progressUpdateStream(model.progressUpdateStream);
            migrationTaskName(model.migrationTaskName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getProgressUpdateStream() {
            return progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDiscoveredResourcesRequest build() {
            return new ListDiscoveredResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
