/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary;

@SdkInternalApi
public class MigrationTaskSummaryMarshaller {
    private static final MarshallingInfo<String> PROGRESSUPDATESTREAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProgressUpdateStream").build();
    private static final MarshallingInfo<String> MIGRATIONTASKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MigrationTaskName").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Integer> PROGRESSPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProgressPercent").build();
    private static final MarshallingInfo<String> STATUSDETAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetail").build();
    private static final MarshallingInfo<Instant> UPDATEDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateDateTime").build();
    private static final MigrationTaskSummaryMarshaller INSTANCE = new MigrationTaskSummaryMarshaller();

    public static MigrationTaskSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MigrationTaskSummary migrationTaskSummary, ProtocolMarshaller protocolMarshaller) {
        if (migrationTaskSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)migrationTaskSummary.progressUpdateStream(), PROGRESSUPDATESTREAM_BINDING);
            protocolMarshaller.marshall((Object)migrationTaskSummary.migrationTaskName(), MIGRATIONTASKNAME_BINDING);
            protocolMarshaller.marshall((Object)migrationTaskSummary.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)migrationTaskSummary.progressPercent(), PROGRESSPERCENT_BINDING);
            protocolMarshaller.marshall((Object)migrationTaskSummary.statusDetail(), STATUSDETAIL_BINDING);
            protocolMarshaller.marshall((Object)migrationTaskSummary.updateDateTime(), UPDATEDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

