/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.migrationhub.model.DiscoveredResource;

@SdkInternalApi
public class DiscoveredResourceMarshaller {
    private static final MarshallingInfo<String> CONFIGURATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationId").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final DiscoveredResourceMarshaller INSTANCE = new DiscoveredResourceMarshaller();

    public static DiscoveredResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DiscoveredResource discoveredResource, ProtocolMarshaller protocolMarshaller) {
        if (discoveredResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)discoveredResource.configurationId(), CONFIGURATIONID_BINDING);
            protocolMarshaller.marshall((Object)discoveredResource.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

