/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.migrationhub.model.DiscoveredResource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DiscoveredResourceMarshaller {
    private static final MarshallingInfo<String> CONFIGURATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationId").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final DiscoveredResourceMarshaller INSTANCE = new DiscoveredResourceMarshaller();

    private DiscoveredResourceMarshaller() {
    }

    public static DiscoveredResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DiscoveredResource discoveredResource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)discoveredResource, (String)"discoveredResource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)discoveredResource.configurationId(), CONFIGURATIONID_BINDING);
            protocolMarshaller.marshall((Object)discoveredResource.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

