/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.migrationhub.transform.DiscoveredResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoveredResource
implements StructuredPojo,
ToCopyableBuilder<Builder, DiscoveredResource> {
    private final String configurationId;
    private final String description;

    private DiscoveredResource(BuilderImpl builder) {
        this.configurationId = builder.configurationId;
        this.description = builder.description;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoveredResource)) {
            return false;
        }
        DiscoveredResource other = (DiscoveredResource)obj;
        return Objects.equals(this.configurationId(), other.configurationId()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"DiscoveredResource").add("ConfigurationId", (Object)this.configurationId()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.configurationId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiscoveredResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationId;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoveredResource model) {
            this.configurationId(model.configurationId);
            this.description(model.description);
        }

        public final String getConfigurationId() {
            return this.configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public DiscoveredResource build() {
            return new DiscoveredResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DiscoveredResource> {
        public Builder configurationId(String var1);

        public Builder description(String var1);
    }
}

