/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.migrationhub.model.ResourceAttribute;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceAttributeMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final ResourceAttributeMarshaller INSTANCE = new ResourceAttributeMarshaller();

    private ResourceAttributeMarshaller() {
    }

    public static ResourceAttributeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceAttribute resourceAttribute, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceAttribute, (String)"resourceAttribute");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceAttribute.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceAttribute.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

