/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.migrationhub.model.MigrationTask;
import software.amazon.awssdk.services.migrationhub.transform.ResourceAttributeUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.TaskUnmarshaller;

public class MigrationTaskUnmarshaller
implements Unmarshaller<MigrationTask, JsonUnmarshallerContext> {
    private static final MigrationTaskUnmarshaller INSTANCE = new MigrationTaskUnmarshaller();

    public MigrationTask unmarshall(JsonUnmarshallerContext context) throws Exception {
        MigrationTask.Builder migrationTaskBuilder = MigrationTask.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ProgressUpdateStream", targetDepth)) {
                    context.nextToken();
                    migrationTaskBuilder.progressUpdateStream((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MigrationTaskName", targetDepth)) {
                    context.nextToken();
                    migrationTaskBuilder.migrationTaskName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Task", targetDepth)) {
                    context.nextToken();
                    migrationTaskBuilder.task(TaskUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("UpdateDateTime", targetDepth)) {
                    context.nextToken();
                    migrationTaskBuilder.updateDateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResourceAttributeList", targetDepth)) {
                    context.nextToken();
                    migrationTaskBuilder.resourceAttributeList(new ListUnmarshaller((Unmarshaller)ResourceAttributeUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (MigrationTask)migrationTaskBuilder.build();
    }

    public static MigrationTaskUnmarshaller getInstance() {
        return INSTANCE;
    }
}

