/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubRequest;
import software.amazon.awssdk.services.migrationhub.model.Task;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NotifyMigrationTaskStateRequest
extends MigrationHubRequest
implements ToCopyableBuilder<Builder, NotifyMigrationTaskStateRequest> {
    private final String progressUpdateStream;
    private final String migrationTaskName;
    private final Task task;
    private final Instant updateDateTime;
    private final Integer nextUpdateSeconds;
    private final Boolean dryRun;

    private NotifyMigrationTaskStateRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.task = builder.task;
        this.updateDateTime = builder.updateDateTime;
        this.nextUpdateSeconds = builder.nextUpdateSeconds;
        this.dryRun = builder.dryRun;
    }

    public String progressUpdateStream() {
        return this.progressUpdateStream;
    }

    public String migrationTaskName() {
        return this.migrationTaskName;
    }

    public Task task() {
        return this.task;
    }

    public Instant updateDateTime() {
        return this.updateDateTime;
    }

    public Integer nextUpdateSeconds() {
        return this.nextUpdateSeconds;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.task());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextUpdateSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyMigrationTaskStateRequest)) {
            return false;
        }
        NotifyMigrationTaskStateRequest other = (NotifyMigrationTaskStateRequest)((Object)obj);
        return Objects.equals(this.progressUpdateStream(), other.progressUpdateStream()) && Objects.equals(this.migrationTaskName(), other.migrationTaskName()) && Objects.equals(this.task(), other.task()) && Objects.equals(this.updateDateTime(), other.updateDateTime()) && Objects.equals(this.nextUpdateSeconds(), other.nextUpdateSeconds()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public String toString() {
        return ToString.builder((String)"NotifyMigrationTaskStateRequest").add("ProgressUpdateStream", (Object)this.progressUpdateStream()).add("MigrationTaskName", (Object)this.migrationTaskName()).add("Task", (Object)this.task()).add("UpdateDateTime", (Object)this.updateDateTime()).add("NextUpdateSeconds", (Object)this.nextUpdateSeconds()).add("DryRun", (Object)this.dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressUpdateStream": {
                return Optional.of(clazz.cast(this.progressUpdateStream()));
            }
            case "MigrationTaskName": {
                return Optional.of(clazz.cast(this.migrationTaskName()));
            }
            case "Task": {
                return Optional.of(clazz.cast(this.task()));
            }
            case "UpdateDateTime": {
                return Optional.of(clazz.cast(this.updateDateTime()));
            }
            case "NextUpdateSeconds": {
                return Optional.of(clazz.cast(this.nextUpdateSeconds()));
            }
            case "DryRun": {
                return Optional.of(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MigrationHubRequest.BuilderImpl
    implements Builder {
        private String progressUpdateStream;
        private String migrationTaskName;
        private Task task;
        private Instant updateDateTime;
        private Integer nextUpdateSeconds;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyMigrationTaskStateRequest model) {
            super(model);
            this.progressUpdateStream(model.progressUpdateStream);
            this.migrationTaskName(model.migrationTaskName);
            this.task(model.task);
            this.updateDateTime(model.updateDateTime);
            this.nextUpdateSeconds(model.nextUpdateSeconds);
            this.dryRun(model.dryRun);
        }

        public final String getProgressUpdateStream() {
            return this.progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return this.migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final Task.Builder getTask() {
            return this.task != null ? this.task.toBuilder() : null;
        }

        @Override
        public final Builder task(Task task) {
            this.task = task;
            return this;
        }

        public final void setTask(Task.BuilderImpl task) {
            this.task = task != null ? task.build() : null;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        public final Integer getNextUpdateSeconds() {
            return this.nextUpdateSeconds;
        }

        @Override
        public final Builder nextUpdateSeconds(Integer nextUpdateSeconds) {
            this.nextUpdateSeconds = nextUpdateSeconds;
            return this;
        }

        public final void setNextUpdateSeconds(Integer nextUpdateSeconds) {
            this.nextUpdateSeconds = nextUpdateSeconds;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public NotifyMigrationTaskStateRequest build() {
            return new NotifyMigrationTaskStateRequest(this);
        }
    }

    public static interface Builder
    extends MigrationHubRequest.Builder,
    CopyableBuilder<Builder, NotifyMigrationTaskStateRequest> {
        public Builder progressUpdateStream(String var1);

        public Builder migrationTaskName(String var1);

        public Builder task(Task var1);

        default public Builder task(Consumer<Task.Builder> task) {
            return this.task((Task)((Task.Builder)Task.builder().apply(task)).build());
        }

        public Builder updateDateTime(Instant var1);

        public Builder nextUpdateSeconds(Integer var1);

        public Builder dryRun(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

