/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mgn.model.WaveIDsFilterCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWavesRequestFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListWavesRequestFilters> {
    private static final SdkField<List<String>> WAVE_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("waveIDs").getter(ListWavesRequestFilters.getter(ListWavesRequestFilters::waveIDs)).setter(ListWavesRequestFilters.setter(Builder::waveIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waveIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isArchived").getter(ListWavesRequestFilters.getter(ListWavesRequestFilters::isArchived)).setter(ListWavesRequestFilters.setter(Builder::isArchived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WAVE_I_DS_FIELD, IS_ARCHIVED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWavesRequestFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> waveIDs;
    private final Boolean isArchived;

    private ListWavesRequestFilters(BuilderImpl builder) {
        this.waveIDs = builder.waveIDs;
        this.isArchived = builder.isArchived;
    }

    public final boolean hasWaveIDs() {
        return this.waveIDs != null && !(this.waveIDs instanceof SdkAutoConstructList);
    }

    public final List<String> waveIDs() {
        return this.waveIDs;
    }

    public final Boolean isArchived() {
        return this.isArchived;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWaveIDs() ? this.waveIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isArchived());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWavesRequestFilters)) {
            return false;
        }
        ListWavesRequestFilters other = (ListWavesRequestFilters)obj;
        return this.hasWaveIDs() == other.hasWaveIDs() && Objects.equals(this.waveIDs(), other.waveIDs()) && Objects.equals(this.isArchived(), other.isArchived());
    }

    public final String toString() {
        return ToString.builder((String)"ListWavesRequestFilters").add("WaveIDs", this.hasWaveIDs() ? this.waveIDs() : null).add("IsArchived", (Object)this.isArchived()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "waveIDs": {
                return Optional.ofNullable(clazz.cast(this.waveIDs()));
            }
            case "isArchived": {
                return Optional.ofNullable(clazz.cast(this.isArchived()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("waveIDs", WAVE_I_DS_FIELD);
        map.put("isArchived", IS_ARCHIVED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWavesRequestFilters, T> g) {
        return obj -> g.apply((ListWavesRequestFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> waveIDs = DefaultSdkAutoConstructList.getInstance();
        private Boolean isArchived;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWavesRequestFilters model) {
            this.waveIDs(model.waveIDs);
            this.isArchived(model.isArchived);
        }

        public final Collection<String> getWaveIDs() {
            if (this.waveIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.waveIDs;
        }

        public final void setWaveIDs(Collection<String> waveIDs) {
            this.waveIDs = WaveIDsFilterCopier.copy(waveIDs);
        }

        @Override
        public final Builder waveIDs(Collection<String> waveIDs) {
            this.waveIDs = WaveIDsFilterCopier.copy(waveIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder waveIDs(String ... waveIDs) {
            this.waveIDs(Arrays.asList(waveIDs));
            return this;
        }

        public final Boolean getIsArchived() {
            return this.isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public ListWavesRequestFilters build() {
            return new ListWavesRequestFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListWavesRequestFilters> {
        public Builder waveIDs(Collection<String> var1);

        public Builder waveIDs(String ... var1);

        public Builder isArchived(Boolean var1);
    }
}

