/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.ExportStatus;
import software.amazon.awssdk.services.mgn.model.ExportTaskSummary;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportTask> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportID").getter(ExportTask.getter(ExportTask::exportID)).setter(ExportTask.setter(Builder::exportID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportID").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ExportTask.getter(ExportTask::arn)).setter(ExportTask.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Bucket").getter(ExportTask.getter(ExportTask::s3Bucket)).setter(ExportTask.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<String> S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Key").getter(ExportTask.getter(ExportTask::s3Key)).setter(ExportTask.setter(Builder::s3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Key").build()}).build();
    private static final SdkField<String> S3_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketOwner").getter(ExportTask.getter(ExportTask::s3BucketOwner)).setter(ExportTask.setter(Builder::s3BucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketOwner").build()}).build();
    private static final SdkField<String> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creationDateTime").getter(ExportTask.getter(ExportTask::creationDateTime)).setter(ExportTask.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<String> END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endDateTime").getter(ExportTask.getter(ExportTask::endDateTime)).setter(ExportTask.setter(Builder::endDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ExportTask.getter(ExportTask::statusAsString)).setter(ExportTask.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Float> PROGRESS_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("progressPercentage").getter(ExportTask.getter(ExportTask::progressPercentage)).setter(ExportTask.setter(Builder::progressPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercentage").build()}).build();
    private static final SdkField<ExportTaskSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("summary").getter(ExportTask.getter(ExportTask::summary)).setter(ExportTask.setter(Builder::summary)).constructor(ExportTaskSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ExportTask.getter(ExportTask::tags)).setter(ExportTask.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD, ARN_FIELD, S3_BUCKET_FIELD, S3_KEY_FIELD, S3_BUCKET_OWNER_FIELD, CREATION_DATE_TIME_FIELD, END_DATE_TIME_FIELD, STATUS_FIELD, PROGRESS_PERCENTAGE_FIELD, SUMMARY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportTask.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String exportID;
    private final String arn;
    private final String s3Bucket;
    private final String s3Key;
    private final String s3BucketOwner;
    private final String creationDateTime;
    private final String endDateTime;
    private final String status;
    private final Float progressPercentage;
    private final ExportTaskSummary summary;
    private final Map<String, String> tags;

    private ExportTask(BuilderImpl builder) {
        this.exportID = builder.exportID;
        this.arn = builder.arn;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3BucketOwner = builder.s3BucketOwner;
        this.creationDateTime = builder.creationDateTime;
        this.endDateTime = builder.endDateTime;
        this.status = builder.status;
        this.progressPercentage = builder.progressPercentage;
        this.summary = builder.summary;
        this.tags = builder.tags;
    }

    public final String exportID() {
        return this.exportID;
    }

    public final String arn() {
        return this.arn;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3Key() {
        return this.s3Key;
    }

    public final String s3BucketOwner() {
        return this.s3BucketOwner;
    }

    public final String creationDateTime() {
        return this.creationDateTime;
    }

    public final String endDateTime() {
        return this.endDateTime;
    }

    public final ExportStatus status() {
        return ExportStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Float progressPercentage() {
        return this.progressPercentage;
    }

    public final ExportTaskSummary summary() {
        return this.summary;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportID());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTask)) {
            return false;
        }
        ExportTask other = (ExportTask)obj;
        return Objects.equals(this.exportID(), other.exportID()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Key(), other.s3Key()) && Objects.equals(this.s3BucketOwner(), other.s3BucketOwner()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.progressPercentage(), other.progressPercentage()) && Objects.equals(this.summary(), other.summary()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ExportTask").add("ExportID", (Object)this.exportID()).add("Arn", (Object)this.arn()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Key", (Object)this.s3Key()).add("S3BucketOwner", (Object)this.s3BucketOwner()).add("CreationDateTime", (Object)this.creationDateTime()).add("EndDateTime", (Object)this.endDateTime()).add("Status", (Object)this.statusAsString()).add("ProgressPercentage", (Object)this.progressPercentage()).add("Summary", (Object)this.summary()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportID": {
                return Optional.ofNullable(clazz.cast(this.exportID()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "s3Key": {
                return Optional.ofNullable(clazz.cast(this.s3Key()));
            }
            case "s3BucketOwner": {
                return Optional.ofNullable(clazz.cast(this.s3BucketOwner()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "endDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "progressPercentage": {
                return Optional.ofNullable(clazz.cast(this.progressPercentage()));
            }
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exportID", EXPORT_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("s3Bucket", S3_BUCKET_FIELD);
        map.put("s3Key", S3_KEY_FIELD);
        map.put("s3BucketOwner", S3_BUCKET_OWNER_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("endDateTime", END_DATE_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("progressPercentage", PROGRESS_PERCENTAGE_FIELD);
        map.put("summary", SUMMARY_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportTask, T> g) {
        return obj -> g.apply((ExportTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportID;
        private String arn;
        private String s3Bucket;
        private String s3Key;
        private String s3BucketOwner;
        private String creationDateTime;
        private String endDateTime;
        private String status;
        private Float progressPercentage;
        private ExportTaskSummary summary;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTask model) {
            this.exportID(model.exportID);
            this.arn(model.arn);
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
            this.s3BucketOwner(model.s3BucketOwner);
            this.creationDateTime(model.creationDateTime);
            this.endDateTime(model.endDateTime);
            this.status(model.status);
            this.progressPercentage(model.progressPercentage);
            this.summary(model.summary);
            this.tags(model.tags);
        }

        public final String getExportID() {
            return this.exportID;
        }

        public final void setExportID(String exportID) {
            this.exportID = exportID;
        }

        @Override
        public final Builder exportID(String exportID) {
            this.exportID = exportID;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final String getS3BucketOwner() {
            return this.s3BucketOwner;
        }

        public final void setS3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
        }

        @Override
        public final Builder s3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
            return this;
        }

        public final String getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getEndDateTime() {
            return this.endDateTime;
        }

        public final void setEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Float getProgressPercentage() {
            return this.progressPercentage;
        }

        public final void setProgressPercentage(Float progressPercentage) {
            this.progressPercentage = progressPercentage;
        }

        @Override
        public final Builder progressPercentage(Float progressPercentage) {
            this.progressPercentage = progressPercentage;
            return this;
        }

        public final ExportTaskSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(ExportTaskSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(ExportTaskSummary summary) {
            this.summary = summary;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public ExportTask build() {
            return new ExportTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportTask> {
        public Builder exportID(String var1);

        public Builder arn(String var1);

        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);

        public Builder s3BucketOwner(String var1);

        public Builder creationDateTime(String var1);

        public Builder endDateTime(String var1);

        public Builder status(String var1);

        public Builder status(ExportStatus var1);

        public Builder progressPercentage(Float var1);

        public Builder summary(ExportTaskSummary var1);

        default public Builder summary(Consumer<ExportTaskSummary.Builder> summary) {
            return this.summary((ExportTaskSummary)((ExportTaskSummary.Builder)ExportTaskSummary.builder().applyMutation(summary)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

