/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * AWS Systems Manager Document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SsmDocument implements SdkPojo, Serializable, ToCopyableBuilder<SsmDocument.Builder, SsmDocument> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionName").getter(getter(SsmDocument::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<Map<String, SsmExternalParameter>> EXTERNAL_PARAMETERS_FIELD = SdkField
            .<Map<String, SsmExternalParameter>> builder(MarshallingType.MAP)
            .memberName("externalParameters")
            .getter(getter(SsmDocument::externalParameters))
            .setter(setter(Builder::externalParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SsmExternalParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SsmExternalParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> MUST_SUCCEED_FOR_CUTOVER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("mustSucceedForCutover").getter(getter(SsmDocument::mustSucceedForCutover))
            .setter(setter(Builder::mustSucceedForCutover))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mustSucceedForCutover").build())
            .build();

    private static final SdkField<Map<String, List<SsmParameterStoreParameter>>> PARAMETERS_FIELD = SdkField
            .<Map<String, List<SsmParameterStoreParameter>>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(SsmDocument::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<SsmParameterStoreParameter>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<SsmParameterStoreParameter> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(SsmParameterStoreParameter::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> SSM_DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ssmDocumentName").getter(getter(SsmDocument::ssmDocumentName)).setter(setter(Builder::ssmDocumentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmDocumentName").build()).build();

    private static final SdkField<Integer> TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutSeconds").getter(getter(SsmDocument::timeoutSeconds)).setter(setter(Builder::timeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            EXTERNAL_PARAMETERS_FIELD, MUST_SUCCEED_FOR_CUTOVER_FIELD, PARAMETERS_FIELD, SSM_DOCUMENT_NAME_FIELD,
            TIMEOUT_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionName;

    private final Map<String, SsmExternalParameter> externalParameters;

    private final Boolean mustSucceedForCutover;

    private final Map<String, List<SsmParameterStoreParameter>> parameters;

    private final String ssmDocumentName;

    private final Integer timeoutSeconds;

    private SsmDocument(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.externalParameters = builder.externalParameters;
        this.mustSucceedForCutover = builder.mustSucceedForCutover;
        this.parameters = builder.parameters;
        this.ssmDocumentName = builder.ssmDocumentName;
        this.timeoutSeconds = builder.timeoutSeconds;
    }

    /**
     * <p>
     * User-friendly name for the AWS Systems Manager Document.
     * </p>
     * 
     * @return User-friendly name for the AWS Systems Manager Document.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExternalParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExternalParameters() {
        return externalParameters != null && !(externalParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * AWS Systems Manager Document external parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExternalParameters} method.
     * </p>
     * 
     * @return AWS Systems Manager Document external parameters.
     */
    public final Map<String, SsmExternalParameter> externalParameters() {
        return externalParameters;
    }

    /**
     * <p>
     * If true, Cutover will not be enabled if the document has failed.
     * </p>
     * 
     * @return If true, Cutover will not be enabled if the document has failed.
     */
    public final Boolean mustSucceedForCutover() {
        return mustSucceedForCutover;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * AWS Systems Manager Document parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return AWS Systems Manager Document parameters.
     */
    public final Map<String, List<SsmParameterStoreParameter>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * AWS Systems Manager Document name or full ARN.
     * </p>
     * 
     * @return AWS Systems Manager Document name or full ARN.
     */
    public final String ssmDocumentName() {
        return ssmDocumentName;
    }

    /**
     * <p>
     * AWS Systems Manager Document timeout seconds.
     * </p>
     * 
     * @return AWS Systems Manager Document timeout seconds.
     */
    public final Integer timeoutSeconds() {
        return timeoutSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasExternalParameters() ? externalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mustSucceedForCutover());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ssmDocumentName());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmDocument)) {
            return false;
        }
        SsmDocument other = (SsmDocument) obj;
        return Objects.equals(actionName(), other.actionName()) && hasExternalParameters() == other.hasExternalParameters()
                && Objects.equals(externalParameters(), other.externalParameters())
                && Objects.equals(mustSucceedForCutover(), other.mustSucceedForCutover())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(ssmDocumentName(), other.ssmDocumentName())
                && Objects.equals(timeoutSeconds(), other.timeoutSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SsmDocument").add("ActionName", actionName())
                .add("ExternalParameters", hasExternalParameters() ? externalParameters() : null)
                .add("MustSucceedForCutover", mustSucceedForCutover()).add("Parameters", hasParameters() ? parameters() : null)
                .add("SsmDocumentName", ssmDocumentName()).add("TimeoutSeconds", timeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "externalParameters":
            return Optional.ofNullable(clazz.cast(externalParameters()));
        case "mustSucceedForCutover":
            return Optional.ofNullable(clazz.cast(mustSucceedForCutover()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ssmDocumentName":
            return Optional.ofNullable(clazz.cast(ssmDocumentName()));
        case "timeoutSeconds":
            return Optional.ofNullable(clazz.cast(timeoutSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionName", ACTION_NAME_FIELD);
        map.put("externalParameters", EXTERNAL_PARAMETERS_FIELD);
        map.put("mustSucceedForCutover", MUST_SUCCEED_FOR_CUTOVER_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("ssmDocumentName", SSM_DOCUMENT_NAME_FIELD);
        map.put("timeoutSeconds", TIMEOUT_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SsmDocument, T> g) {
        return obj -> g.apply((SsmDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SsmDocument> {
        /**
         * <p>
         * User-friendly name for the AWS Systems Manager Document.
         * </p>
         * 
         * @param actionName
         *        User-friendly name for the AWS Systems Manager Document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * AWS Systems Manager Document external parameters.
         * </p>
         * 
         * @param externalParameters
         *        AWS Systems Manager Document external parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalParameters(Map<String, SsmExternalParameter> externalParameters);

        /**
         * <p>
         * If true, Cutover will not be enabled if the document has failed.
         * </p>
         * 
         * @param mustSucceedForCutover
         *        If true, Cutover will not be enabled if the document has failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mustSucceedForCutover(Boolean mustSucceedForCutover);

        /**
         * <p>
         * AWS Systems Manager Document parameters.
         * </p>
         * 
         * @param parameters
         *        AWS Systems Manager Document parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<SsmParameterStoreParameter>> parameters);

        /**
         * <p>
         * AWS Systems Manager Document name or full ARN.
         * </p>
         * 
         * @param ssmDocumentName
         *        AWS Systems Manager Document name or full ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmDocumentName(String ssmDocumentName);

        /**
         * <p>
         * AWS Systems Manager Document timeout seconds.
         * </p>
         * 
         * @param timeoutSeconds
         *        AWS Systems Manager Document timeout seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutSeconds(Integer timeoutSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String actionName;

        private Map<String, SsmExternalParameter> externalParameters = DefaultSdkAutoConstructMap.getInstance();

        private Boolean mustSucceedForCutover;

        private Map<String, List<SsmParameterStoreParameter>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String ssmDocumentName;

        private Integer timeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(SsmDocument model) {
            actionName(model.actionName);
            externalParameters(model.externalParameters);
            mustSucceedForCutover(model.mustSucceedForCutover);
            parameters(model.parameters);
            ssmDocumentName(model.ssmDocumentName);
            timeoutSeconds(model.timeoutSeconds);
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final Map<String, SsmExternalParameter.Builder> getExternalParameters() {
            Map<String, SsmExternalParameter.Builder> result = SsmDocumentExternalParametersCopier
                    .copyToBuilder(this.externalParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExternalParameters(Map<String, SsmExternalParameter.BuilderImpl> externalParameters) {
            this.externalParameters = SsmDocumentExternalParametersCopier.copyFromBuilder(externalParameters);
        }

        @Override
        public final Builder externalParameters(Map<String, SsmExternalParameter> externalParameters) {
            this.externalParameters = SsmDocumentExternalParametersCopier.copy(externalParameters);
            return this;
        }

        public final Boolean getMustSucceedForCutover() {
            return mustSucceedForCutover;
        }

        public final void setMustSucceedForCutover(Boolean mustSucceedForCutover) {
            this.mustSucceedForCutover = mustSucceedForCutover;
        }

        @Override
        public final Builder mustSucceedForCutover(Boolean mustSucceedForCutover) {
            this.mustSucceedForCutover = mustSucceedForCutover;
            return this;
        }

        public final Map<String, List<SsmParameterStoreParameter.Builder>> getParameters() {
            Map<String, List<SsmParameterStoreParameter.Builder>> result = SsmDocumentParametersCopier
                    .copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, ? extends Collection<SsmParameterStoreParameter.BuilderImpl>> parameters) {
            this.parameters = SsmDocumentParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<SsmParameterStoreParameter>> parameters) {
            this.parameters = SsmDocumentParametersCopier.copy(parameters);
            return this;
        }

        public final String getSsmDocumentName() {
            return ssmDocumentName;
        }

        public final void setSsmDocumentName(String ssmDocumentName) {
            this.ssmDocumentName = ssmDocumentName;
        }

        @Override
        public final Builder ssmDocumentName(String ssmDocumentName) {
            this.ssmDocumentName = ssmDocumentName;
            return this;
        }

        public final Integer getTimeoutSeconds() {
            return timeoutSeconds;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        @Override
        public SsmDocument build() {
            return new SsmDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
