/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.PostLaunchActionExecutionStatus;
import software.amazon.awssdk.services.mgn.model.SsmDocument;
import software.amazon.awssdk.services.mgn.model.SsmDocumentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobPostLaunchActionsLaunchStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobPostLaunchActionsLaunchStatus> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionID").getter(JobPostLaunchActionsLaunchStatus.getter(JobPostLaunchActionsLaunchStatus::executionID)).setter(JobPostLaunchActionsLaunchStatus.setter(Builder::executionID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionID").build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionStatus").getter(JobPostLaunchActionsLaunchStatus.getter(JobPostLaunchActionsLaunchStatus::executionStatusAsString)).setter(JobPostLaunchActionsLaunchStatus.setter(Builder::executionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(JobPostLaunchActionsLaunchStatus.getter(JobPostLaunchActionsLaunchStatus::failureReason)).setter(JobPostLaunchActionsLaunchStatus.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<SsmDocument> SSM_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ssmDocument").getter(JobPostLaunchActionsLaunchStatus.getter(JobPostLaunchActionsLaunchStatus::ssmDocument)).setter(JobPostLaunchActionsLaunchStatus.setter(Builder::ssmDocument)).constructor(SsmDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmDocument").build()}).build();
    private static final SdkField<String> SSM_DOCUMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ssmDocumentType").getter(JobPostLaunchActionsLaunchStatus.getter(JobPostLaunchActionsLaunchStatus::ssmDocumentTypeAsString)).setter(JobPostLaunchActionsLaunchStatus.setter(Builder::ssmDocumentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmDocumentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD, EXECUTION_STATUS_FIELD, FAILURE_REASON_FIELD, SSM_DOCUMENT_FIELD, SSM_DOCUMENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobPostLaunchActionsLaunchStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String executionID;
    private final String executionStatus;
    private final String failureReason;
    private final SsmDocument ssmDocument;
    private final String ssmDocumentType;

    private JobPostLaunchActionsLaunchStatus(BuilderImpl builder) {
        this.executionID = builder.executionID;
        this.executionStatus = builder.executionStatus;
        this.failureReason = builder.failureReason;
        this.ssmDocument = builder.ssmDocument;
        this.ssmDocumentType = builder.ssmDocumentType;
    }

    public final String executionID() {
        return this.executionID;
    }

    public final PostLaunchActionExecutionStatus executionStatus() {
        return PostLaunchActionExecutionStatus.fromValue(this.executionStatus);
    }

    public final String executionStatusAsString() {
        return this.executionStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final SsmDocument ssmDocument() {
        return this.ssmDocument;
    }

    public final SsmDocumentType ssmDocumentType() {
        return SsmDocumentType.fromValue(this.ssmDocumentType);
    }

    public final String ssmDocumentTypeAsString() {
        return this.ssmDocumentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionID());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmDocumentTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobPostLaunchActionsLaunchStatus)) {
            return false;
        }
        JobPostLaunchActionsLaunchStatus other = (JobPostLaunchActionsLaunchStatus)obj;
        return Objects.equals(this.executionID(), other.executionID()) && Objects.equals(this.executionStatusAsString(), other.executionStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.ssmDocument(), other.ssmDocument()) && Objects.equals(this.ssmDocumentTypeAsString(), other.ssmDocumentTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"JobPostLaunchActionsLaunchStatus").add("ExecutionID", (Object)this.executionID()).add("ExecutionStatus", (Object)this.executionStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("SsmDocument", (Object)this.ssmDocument()).add("SsmDocumentType", (Object)this.ssmDocumentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionID": {
                return Optional.ofNullable(clazz.cast(this.executionID()));
            }
            case "executionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatusAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ssmDocument": {
                return Optional.ofNullable(clazz.cast(this.ssmDocument()));
            }
            case "ssmDocumentType": {
                return Optional.ofNullable(clazz.cast(this.ssmDocumentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("executionID", EXECUTION_ID_FIELD);
        map.put("executionStatus", EXECUTION_STATUS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("ssmDocument", SSM_DOCUMENT_FIELD);
        map.put("ssmDocumentType", SSM_DOCUMENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobPostLaunchActionsLaunchStatus, T> g) {
        return obj -> g.apply((JobPostLaunchActionsLaunchStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionID;
        private String executionStatus;
        private String failureReason;
        private SsmDocument ssmDocument;
        private String ssmDocumentType;

        private BuilderImpl() {
        }

        private BuilderImpl(JobPostLaunchActionsLaunchStatus model) {
            this.executionID(model.executionID);
            this.executionStatus(model.executionStatus);
            this.failureReason(model.failureReason);
            this.ssmDocument(model.ssmDocument);
            this.ssmDocumentType(model.ssmDocumentType);
        }

        public final String getExecutionID() {
            return this.executionID;
        }

        public final void setExecutionID(String executionID) {
            this.executionID = executionID;
        }

        @Override
        public final Builder executionID(String executionID) {
            this.executionID = executionID;
            return this;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(PostLaunchActionExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final SsmDocument.Builder getSsmDocument() {
            return this.ssmDocument != null ? this.ssmDocument.toBuilder() : null;
        }

        public final void setSsmDocument(SsmDocument.BuilderImpl ssmDocument) {
            this.ssmDocument = ssmDocument != null ? ssmDocument.build() : null;
        }

        @Override
        public final Builder ssmDocument(SsmDocument ssmDocument) {
            this.ssmDocument = ssmDocument;
            return this;
        }

        public final String getSsmDocumentType() {
            return this.ssmDocumentType;
        }

        public final void setSsmDocumentType(String ssmDocumentType) {
            this.ssmDocumentType = ssmDocumentType;
        }

        @Override
        public final Builder ssmDocumentType(String ssmDocumentType) {
            this.ssmDocumentType = ssmDocumentType;
            return this;
        }

        @Override
        public final Builder ssmDocumentType(SsmDocumentType ssmDocumentType) {
            this.ssmDocumentType(ssmDocumentType == null ? null : ssmDocumentType.toString());
            return this;
        }

        public JobPostLaunchActionsLaunchStatus build() {
            return new JobPostLaunchActionsLaunchStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobPostLaunchActionsLaunchStatus> {
        public Builder executionID(String var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(PostLaunchActionExecutionStatus var1);

        public Builder failureReason(String var1);

        public Builder ssmDocument(SsmDocument var1);

        default public Builder ssmDocument(Consumer<SsmDocument.Builder> ssmDocument) {
            return this.ssmDocument((SsmDocument)((SsmDocument.Builder)SsmDocument.builder().applyMutation(ssmDocument)).build());
        }

        public Builder ssmDocumentType(String var1);

        public Builder ssmDocumentType(SsmDocumentType var1);
    }
}

