/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.ConnectorSsmCommandConfig;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectorRequest
extends MgnRequest
implements ToCopyableBuilder<Builder, CreateConnectorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateConnectorRequest.getter(CreateConnectorRequest::name)).setter(CreateConnectorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ConnectorSsmCommandConfig> SSM_COMMAND_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ssmCommandConfig").getter(CreateConnectorRequest.getter(CreateConnectorRequest::ssmCommandConfig)).setter(CreateConnectorRequest.setter(Builder::ssmCommandConfig)).constructor(ConnectorSsmCommandConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmCommandConfig").build()}).build();
    private static final SdkField<String> SSM_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ssmInstanceID").getter(CreateConnectorRequest.getter(CreateConnectorRequest::ssmInstanceID)).setter(CreateConnectorRequest.setter(Builder::ssmInstanceID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmInstanceID").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateConnectorRequest.getter(CreateConnectorRequest::tags)).setter(CreateConnectorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SSM_COMMAND_CONFIG_FIELD, SSM_INSTANCE_ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectorRequest.memberNameToFieldInitializer();
    private final String name;
    private final ConnectorSsmCommandConfig ssmCommandConfig;
    private final String ssmInstanceID;
    private final Map<String, String> tags;

    private CreateConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ssmCommandConfig = builder.ssmCommandConfig;
        this.ssmInstanceID = builder.ssmInstanceID;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final ConnectorSsmCommandConfig ssmCommandConfig() {
        return this.ssmCommandConfig;
    }

    public final String ssmInstanceID() {
        return this.ssmInstanceID;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmCommandConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmInstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorRequest)) {
            return false;
        }
        CreateConnectorRequest other = (CreateConnectorRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.ssmCommandConfig(), other.ssmCommandConfig()) && Objects.equals(this.ssmInstanceID(), other.ssmInstanceID()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectorRequest").add("Name", (Object)this.name()).add("SsmCommandConfig", (Object)this.ssmCommandConfig()).add("SsmInstanceID", (Object)this.ssmInstanceID()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ssmCommandConfig": {
                return Optional.ofNullable(clazz.cast(this.ssmCommandConfig()));
            }
            case "ssmInstanceID": {
                return Optional.ofNullable(clazz.cast(this.ssmInstanceID()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("ssmCommandConfig", SSM_COMMAND_CONFIG_FIELD);
        map.put("ssmInstanceID", SSM_INSTANCE_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorRequest, T> g) {
        return obj -> g.apply((CreateConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnRequest.BuilderImpl
    implements Builder {
        private String name;
        private ConnectorSsmCommandConfig ssmCommandConfig;
        private String ssmInstanceID;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorRequest model) {
            super(model);
            this.name(model.name);
            this.ssmCommandConfig(model.ssmCommandConfig);
            this.ssmInstanceID(model.ssmInstanceID);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ConnectorSsmCommandConfig.Builder getSsmCommandConfig() {
            return this.ssmCommandConfig != null ? this.ssmCommandConfig.toBuilder() : null;
        }

        public final void setSsmCommandConfig(ConnectorSsmCommandConfig.BuilderImpl ssmCommandConfig) {
            this.ssmCommandConfig = ssmCommandConfig != null ? ssmCommandConfig.build() : null;
        }

        @Override
        public final Builder ssmCommandConfig(ConnectorSsmCommandConfig ssmCommandConfig) {
            this.ssmCommandConfig = ssmCommandConfig;
            return this;
        }

        public final String getSsmInstanceID() {
            return this.ssmInstanceID;
        }

        public final void setSsmInstanceID(String ssmInstanceID) {
            this.ssmInstanceID = ssmInstanceID;
        }

        @Override
        public final Builder ssmInstanceID(String ssmInstanceID) {
            this.ssmInstanceID = ssmInstanceID;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorRequest build() {
            return new CreateConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MgnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectorRequest> {
        public Builder name(String var1);

        public Builder ssmCommandConfig(ConnectorSsmCommandConfig var1);

        default public Builder ssmCommandConfig(Consumer<ConnectorSsmCommandConfig.Builder> ssmCommandConfig) {
            return this.ssmCommandConfig((ConnectorSsmCommandConfig)((ConnectorSsmCommandConfig.Builder)ConnectorSsmCommandConfig.builder().applyMutation(ssmCommandConfig)).build());
        }

        public Builder ssmInstanceID(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

