/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartExportRequest
extends MgnRequest
implements ToCopyableBuilder<Builder, StartExportRequest> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Bucket").getter(StartExportRequest.getter(StartExportRequest::s3Bucket)).setter(StartExportRequest.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<String> S3_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketOwner").getter(StartExportRequest.getter(StartExportRequest::s3BucketOwner)).setter(StartExportRequest.setter(Builder::s3BucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketOwner").build()}).build();
    private static final SdkField<String> S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Key").getter(StartExportRequest.getter(StartExportRequest::s3Key)).setter(StartExportRequest.setter(Builder::s3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, S3_BUCKET_OWNER_FIELD, S3_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("s3Bucket", S3_BUCKET_FIELD);
            this.put("s3BucketOwner", S3_BUCKET_OWNER_FIELD);
            this.put("s3Key", S3_KEY_FIELD);
        }
    });
    private final String s3Bucket;
    private final String s3BucketOwner;
    private final String s3Key;

    private StartExportRequest(BuilderImpl builder) {
        super(builder);
        this.s3Bucket = builder.s3Bucket;
        this.s3BucketOwner = builder.s3BucketOwner;
        this.s3Key = builder.s3Key;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3BucketOwner() {
        return this.s3BucketOwner;
    }

    public final String s3Key() {
        return this.s3Key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportRequest)) {
            return false;
        }
        StartExportRequest other = (StartExportRequest)((Object)obj);
        return Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3BucketOwner(), other.s3BucketOwner()) && Objects.equals(this.s3Key(), other.s3Key());
    }

    public final String toString() {
        return ToString.builder((String)"StartExportRequest").add("S3Bucket", (Object)this.s3Bucket()).add("S3BucketOwner", (Object)this.s3BucketOwner()).add("S3Key", (Object)this.s3Key()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "s3BucketOwner": {
                return Optional.ofNullable(clazz.cast(this.s3BucketOwner()));
            }
            case "s3Key": {
                return Optional.ofNullable(clazz.cast(this.s3Key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartExportRequest, T> g) {
        return obj -> g.apply((StartExportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnRequest.BuilderImpl
    implements Builder {
        private String s3Bucket;
        private String s3BucketOwner;
        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportRequest model) {
            super(model);
            this.s3Bucket(model.s3Bucket);
            this.s3BucketOwner(model.s3BucketOwner);
            this.s3Key(model.s3Key);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3BucketOwner() {
            return this.s3BucketOwner;
        }

        public final void setS3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
        }

        @Override
        public final Builder s3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
            return this;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExportRequest build() {
            return new StartExportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MgnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartExportRequest> {
        public Builder s3Bucket(String var1);

        public Builder s3BucketOwner(String var1);

        public Builder s3Key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

