/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest;
import software.amazon.awssdk.services.mgn.model.ListTemplateActionsResponse;
import software.amazon.awssdk.services.mgn.model.TemplateActionDocument;

public class ListTemplateActionsIterable
implements SdkIterable<ListTemplateActionsResponse> {
    private final MgnClient client;
    private final ListTemplateActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTemplateActionsIterable(MgnClient client, ListTemplateActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTemplateActionsResponseFetcher();
    }

    public Iterator<ListTemplateActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TemplateActionDocument> items() {
        Function<ListTemplateActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTemplateActionsResponseFetcher
    implements SyncPageFetcher<ListTemplateActionsResponse> {
        private ListTemplateActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTemplateActionsResponse nextPage(ListTemplateActionsResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateActionsIterable.this.client.listTemplateActions(ListTemplateActionsIterable.this.firstRequest);
            }
            return ListTemplateActionsIterable.this.client.listTemplateActions((ListTemplateActionsRequest)((Object)ListTemplateActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

