/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnAsyncClient;
import software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest;
import software.amazon.awssdk.services.mgn.model.ListTemplateActionsResponse;
import software.amazon.awssdk.services.mgn.model.TemplateActionDocument;

public class ListTemplateActionsPublisher
implements SdkPublisher<ListTemplateActionsResponse> {
    private final MgnAsyncClient client;
    private final ListTemplateActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTemplateActionsPublisher(MgnAsyncClient client, ListTemplateActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTemplateActionsPublisher(MgnAsyncClient client, ListTemplateActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTemplateActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTemplateActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TemplateActionDocument> items() {
        Function<ListTemplateActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTemplateActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTemplateActionsResponseFetcher
    implements AsyncPageFetcher<ListTemplateActionsResponse> {
        private ListTemplateActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTemplateActionsResponse> nextPage(ListTemplateActionsResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateActionsPublisher.this.client.listTemplateActions(ListTemplateActionsPublisher.this.firstRequest);
            }
            return ListTemplateActionsPublisher.this.client.listTemplateActions((ListTemplateActionsRequest)((Object)ListTemplateActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

