/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbResponse;
import software.amazon.awssdk.services.memorydb.model.MultiRegionParameterGroup;
import software.amazon.awssdk.services.memorydb.model.MultiRegionParameterGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMultiRegionParameterGroupsResponse
extends MemoryDbResponse
implements ToCopyableBuilder<Builder, DescribeMultiRegionParameterGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMultiRegionParameterGroupsResponse.getter(DescribeMultiRegionParameterGroupsResponse::nextToken)).setter(DescribeMultiRegionParameterGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<MultiRegionParameterGroup>> MULTI_REGION_PARAMETER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MultiRegionParameterGroups").getter(DescribeMultiRegionParameterGroupsResponse.getter(DescribeMultiRegionParameterGroupsResponse::multiRegionParameterGroups)).setter(DescribeMultiRegionParameterGroupsResponse.setter(Builder::multiRegionParameterGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionParameterGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiRegionParameterGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MULTI_REGION_PARAMETER_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMultiRegionParameterGroupsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<MultiRegionParameterGroup> multiRegionParameterGroups;

    private DescribeMultiRegionParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.multiRegionParameterGroups = builder.multiRegionParameterGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMultiRegionParameterGroups() {
        return this.multiRegionParameterGroups != null && !(this.multiRegionParameterGroups instanceof SdkAutoConstructList);
    }

    public final List<MultiRegionParameterGroup> multiRegionParameterGroups() {
        return this.multiRegionParameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiRegionParameterGroups() ? this.multiRegionParameterGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMultiRegionParameterGroupsResponse)) {
            return false;
        }
        DescribeMultiRegionParameterGroupsResponse other = (DescribeMultiRegionParameterGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMultiRegionParameterGroups() == other.hasMultiRegionParameterGroups() && Objects.equals(this.multiRegionParameterGroups(), other.multiRegionParameterGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMultiRegionParameterGroupsResponse").add("NextToken", (Object)this.nextToken()).add("MultiRegionParameterGroups", this.hasMultiRegionParameterGroups() ? this.multiRegionParameterGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MultiRegionParameterGroups": {
                return Optional.ofNullable(clazz.cast(this.multiRegionParameterGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MultiRegionParameterGroups", MULTI_REGION_PARAMETER_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMultiRegionParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeMultiRegionParameterGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MultiRegionParameterGroup> multiRegionParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMultiRegionParameterGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.multiRegionParameterGroups(model.multiRegionParameterGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MultiRegionParameterGroup.Builder> getMultiRegionParameterGroups() {
            List<MultiRegionParameterGroup.Builder> result = MultiRegionParameterGroupListCopier.copyToBuilder(this.multiRegionParameterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiRegionParameterGroups(Collection<MultiRegionParameterGroup.BuilderImpl> multiRegionParameterGroups) {
            this.multiRegionParameterGroups = MultiRegionParameterGroupListCopier.copyFromBuilder(multiRegionParameterGroups);
        }

        @Override
        public final Builder multiRegionParameterGroups(Collection<MultiRegionParameterGroup> multiRegionParameterGroups) {
            this.multiRegionParameterGroups = MultiRegionParameterGroupListCopier.copy(multiRegionParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiRegionParameterGroups(MultiRegionParameterGroup ... multiRegionParameterGroups) {
            this.multiRegionParameterGroups(Arrays.asList(multiRegionParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiRegionParameterGroups(Consumer<MultiRegionParameterGroup.Builder> ... multiRegionParameterGroups) {
            this.multiRegionParameterGroups(Stream.of(multiRegionParameterGroups).map(c -> (MultiRegionParameterGroup)((MultiRegionParameterGroup.Builder)MultiRegionParameterGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeMultiRegionParameterGroupsResponse build() {
            return new DescribeMultiRegionParameterGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MemoryDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMultiRegionParameterGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder multiRegionParameterGroups(Collection<MultiRegionParameterGroup> var1);

        public Builder multiRegionParameterGroups(MultiRegionParameterGroup ... var1);

        public Builder multiRegionParameterGroups(Consumer<MultiRegionParameterGroup.Builder> ... var1);
    }
}

