/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpdateStrategy {
    COORDINATED("coordinated"),
    UNCOORDINATED("uncoordinated"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpdateStrategy> VALUE_MAP;
    private final String value;

    private UpdateStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpdateStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpdateStrategy> knownValues() {
        EnumSet<UpdateStrategy> knownValues = EnumSet.allOf(UpdateStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpdateStrategy.class, UpdateStrategy::toString);
    }
}

