/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.RecurringCharge;
import software.amazon.awssdk.services.memorydb.model.RecurringChargeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedNode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedNode> {
    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationId").getter(ReservedNode.getter(ReservedNode::reservationId)).setter(ReservedNode.setter(Builder::reservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationId").build()}).build();
    private static final SdkField<String> RESERVED_NODES_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedNodesOfferingId").getter(ReservedNode.getter(ReservedNode::reservedNodesOfferingId)).setter(ReservedNode.setter(Builder::reservedNodesOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodesOfferingId").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(ReservedNode.getter(ReservedNode::nodeType)).setter(ReservedNode.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ReservedNode.getter(ReservedNode::startTime)).setter(ReservedNode.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(ReservedNode.getter(ReservedNode::duration)).setter(ReservedNode.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FixedPrice").getter(ReservedNode.getter(ReservedNode::fixedPrice)).setter(ReservedNode.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()}).build();
    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NodeCount").getter(ReservedNode.getter(ReservedNode::nodeCount)).setter(ReservedNode.setter(Builder::nodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeCount").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingType").getter(ReservedNode.getter(ReservedNode::offeringType)).setter(ReservedNode.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ReservedNode.getter(ReservedNode::state)).setter(ReservedNode.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecurringCharges").getter(ReservedNode.getter(ReservedNode::recurringCharges)).setter(ReservedNode.setter(Builder::recurringCharges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecurringCharge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(ReservedNode.getter(ReservedNode::arn)).setter(ReservedNode.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATION_ID_FIELD, RESERVED_NODES_OFFERING_ID_FIELD, NODE_TYPE_FIELD, START_TIME_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, NODE_COUNT_FIELD, OFFERING_TYPE_FIELD, STATE_FIELD, RECURRING_CHARGES_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReservationId", RESERVATION_ID_FIELD);
            this.put("ReservedNodesOfferingId", RESERVED_NODES_OFFERING_ID_FIELD);
            this.put("NodeType", NODE_TYPE_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("Duration", DURATION_FIELD);
            this.put("FixedPrice", FIXED_PRICE_FIELD);
            this.put("NodeCount", NODE_COUNT_FIELD);
            this.put("OfferingType", OFFERING_TYPE_FIELD);
            this.put("State", STATE_FIELD);
            this.put("RecurringCharges", RECURRING_CHARGES_FIELD);
            this.put("ARN", ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String reservationId;
    private final String reservedNodesOfferingId;
    private final String nodeType;
    private final Instant startTime;
    private final Integer duration;
    private final Double fixedPrice;
    private final Integer nodeCount;
    private final String offeringType;
    private final String state;
    private final List<RecurringCharge> recurringCharges;
    private final String arn;

    private ReservedNode(BuilderImpl builder) {
        this.reservationId = builder.reservationId;
        this.reservedNodesOfferingId = builder.reservedNodesOfferingId;
        this.nodeType = builder.nodeType;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.nodeCount = builder.nodeCount;
        this.offeringType = builder.offeringType;
        this.state = builder.state;
        this.recurringCharges = builder.recurringCharges;
        this.arn = builder.arn;
    }

    public final String reservationId() {
        return this.reservationId;
    }

    public final String reservedNodesOfferingId() {
        return this.reservedNodesOfferingId;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Double fixedPrice() {
        return this.fixedPrice;
    }

    public final Integer nodeCount() {
        return this.nodeCount;
    }

    public final String offeringType() {
        return this.offeringType;
    }

    public final String state() {
        return this.state;
    }

    public final boolean hasRecurringCharges() {
        return this.recurringCharges != null && !(this.recurringCharges instanceof SdkAutoConstructList);
    }

    public final List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecurringCharges() ? this.recurringCharges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedNode)) {
            return false;
        }
        ReservedNode other = (ReservedNode)obj;
        return Objects.equals(this.reservationId(), other.reservationId()) && Objects.equals(this.reservedNodesOfferingId(), other.reservedNodesOfferingId()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.nodeCount(), other.nodeCount()) && Objects.equals(this.offeringType(), other.offeringType()) && Objects.equals(this.state(), other.state()) && this.hasRecurringCharges() == other.hasRecurringCharges() && Objects.equals(this.recurringCharges(), other.recurringCharges()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedNode").add("ReservationId", (Object)this.reservationId()).add("ReservedNodesOfferingId", (Object)this.reservedNodesOfferingId()).add("NodeType", (Object)this.nodeType()).add("StartTime", (Object)this.startTime()).add("Duration", (Object)this.duration()).add("FixedPrice", (Object)this.fixedPrice()).add("NodeCount", (Object)this.nodeCount()).add("OfferingType", (Object)this.offeringType()).add("State", (Object)this.state()).add("RecurringCharges", this.hasRecurringCharges() ? this.recurringCharges() : null).add("ARN", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservationId": {
                return Optional.ofNullable(clazz.cast(this.reservationId()));
            }
            case "ReservedNodesOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedNodesOfferingId()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "NodeCount": {
                return Optional.ofNullable(clazz.cast(this.nodeCount()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringType()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReservedNode, T> g) {
        return obj -> g.apply((ReservedNode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservationId;
        private String reservedNodesOfferingId;
        private String nodeType;
        private Instant startTime;
        private Integer duration;
        private Double fixedPrice;
        private Integer nodeCount;
        private String offeringType;
        private String state;
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedNode model) {
            this.reservationId(model.reservationId);
            this.reservedNodesOfferingId(model.reservedNodesOfferingId);
            this.nodeType(model.nodeType);
            this.startTime(model.startTime);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.nodeCount(model.nodeCount);
            this.offeringType(model.offeringType);
            this.state(model.state);
            this.recurringCharges(model.recurringCharges);
            this.arn(model.arn);
        }

        public final String getReservationId() {
            return this.reservationId;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final String getReservedNodesOfferingId() {
            return this.reservedNodesOfferingId;
        }

        public final void setReservedNodesOfferingId(String reservedNodesOfferingId) {
            this.reservedNodesOfferingId = reservedNodesOfferingId;
        }

        @Override
        public final Builder reservedNodesOfferingId(String reservedNodesOfferingId) {
            this.reservedNodesOfferingId = reservedNodesOfferingId;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final Integer getNodeCount() {
            return this.nodeCount;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargeListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public ReservedNode build() {
            return new ReservedNode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedNode> {
        public Builder reservationId(String var1);

        public Builder reservedNodesOfferingId(String var1);

        public Builder nodeType(String var1);

        public Builder startTime(Instant var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder nodeCount(Integer var1);

        public Builder offeringType(String var1);

        public Builder state(String var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);

        public Builder arn(String var1);
    }
}

