/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbClient;
import software.amazon.awssdk.services.memorydb.internal.UserAgentUtils;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.SubnetGroup;

public class DescribeSubnetGroupsIterable
implements SdkIterable<DescribeSubnetGroupsResponse> {
    private final MemoryDbClient client;
    private final DescribeSubnetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSubnetGroupsIterable(MemoryDbClient client, DescribeSubnetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSubnetGroupsResponseFetcher();
    }

    public Iterator<DescribeSubnetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SubnetGroup> subnetGroups() {
        Function<DescribeSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subnetGroups() != null) {
                return response.subnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSubnetGroupsResponseFetcher
    implements SyncPageFetcher<DescribeSubnetGroupsResponse> {
        private DescribeSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSubnetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSubnetGroupsResponse nextPage(DescribeSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSubnetGroupsIterable.this.client.describeSubnetGroups(DescribeSubnetGroupsIterable.this.firstRequest);
            }
            return DescribeSubnetGroupsIterable.this.client.describeSubnetGroups((DescribeSubnetGroupsRequest)((Object)DescribeSubnetGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

