/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbAsyncClient;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse;
import software.amazon.awssdk.services.memorydb.model.EngineVersionInfo;

public class DescribeEngineVersionsPublisher
implements SdkPublisher<DescribeEngineVersionsResponse> {
    private final MemoryDbAsyncClient client;
    private final DescribeEngineVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEngineVersionsPublisher(MemoryDbAsyncClient client, DescribeEngineVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEngineVersionsPublisher(MemoryDbAsyncClient client, DescribeEngineVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEngineVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEngineVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EngineVersionInfo> engineVersions() {
        Function<DescribeEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.engineVersions() != null) {
                return response.engineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEngineVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEngineVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeEngineVersionsResponse> {
        private DescribeEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeEngineVersionsResponse> nextPage(DescribeEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEngineVersionsPublisher.this.client.describeEngineVersions(DescribeEngineVersionsPublisher.this.firstRequest);
            }
            return DescribeEngineVersionsPublisher.this.client.describeEngineVersions((DescribeEngineVersionsRequest)((Object)DescribeEngineVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

