/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.ACLClusterNameListCopier;
import software.amazon.awssdk.services.memorydb.model.ACLPendingChanges;
import software.amazon.awssdk.services.memorydb.model.UserNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ACL
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ACL> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ACL.getter(ACL::name)).setter(ACL.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ACL.getter(ACL::status)).setter(ACL.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> USER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserNames").getter(ACL.getter(ACL::userNames)).setter(ACL.setter(Builder::userNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MINIMUM_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinimumEngineVersion").getter(ACL.getter(ACL::minimumEngineVersion)).setter(ACL.setter(Builder::minimumEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumEngineVersion").build()}).build();
    private static final SdkField<ACLPendingChanges> PENDING_CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingChanges").getter(ACL.getter(ACL::pendingChanges)).setter(ACL.setter(Builder::pendingChanges)).constructor(ACLPendingChanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingChanges").build()}).build();
    private static final SdkField<List<String>> CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Clusters").getter(ACL.getter(ACL::clusters)).setter(ACL.setter(Builder::clusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Clusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(ACL.getter(ACL::arn)).setter(ACL.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, USER_NAMES_FIELD, MINIMUM_ENGINE_VERSION_FIELD, PENDING_CHANGES_FIELD, CLUSTERS_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String status;
    private final List<String> userNames;
    private final String minimumEngineVersion;
    private final ACLPendingChanges pendingChanges;
    private final List<String> clusters;
    private final String arn;

    private ACL(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.userNames = builder.userNames;
        this.minimumEngineVersion = builder.minimumEngineVersion;
        this.pendingChanges = builder.pendingChanges;
        this.clusters = builder.clusters;
        this.arn = builder.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String status() {
        return this.status;
    }

    public final boolean hasUserNames() {
        return this.userNames != null && !(this.userNames instanceof SdkAutoConstructList);
    }

    public final List<String> userNames() {
        return this.userNames;
    }

    public final String minimumEngineVersion() {
        return this.minimumEngineVersion;
    }

    public final ACLPendingChanges pendingChanges() {
        return this.pendingChanges;
    }

    public final boolean hasClusters() {
        return this.clusters != null && !(this.clusters instanceof SdkAutoConstructList);
    }

    public final List<String> clusters() {
        return this.clusters;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserNames() ? this.userNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingChanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusters() ? this.clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ACL)) {
            return false;
        }
        ACL other = (ACL)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && this.hasUserNames() == other.hasUserNames() && Objects.equals(this.userNames(), other.userNames()) && Objects.equals(this.minimumEngineVersion(), other.minimumEngineVersion()) && Objects.equals(this.pendingChanges(), other.pendingChanges()) && this.hasClusters() == other.hasClusters() && Objects.equals(this.clusters(), other.clusters()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"ACL").add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("UserNames", this.hasUserNames() ? this.userNames() : null).add("MinimumEngineVersion", (Object)this.minimumEngineVersion()).add("PendingChanges", (Object)this.pendingChanges()).add("Clusters", this.hasClusters() ? this.clusters() : null).add("ARN", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "UserNames": {
                return Optional.ofNullable(clazz.cast(this.userNames()));
            }
            case "MinimumEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.minimumEngineVersion()));
            }
            case "PendingChanges": {
                return Optional.ofNullable(clazz.cast(this.pendingChanges()));
            }
            case "Clusters": {
                return Optional.ofNullable(clazz.cast(this.clusters()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ACL, T> g) {
        return obj -> g.apply((ACL)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private List<String> userNames = DefaultSdkAutoConstructList.getInstance();
        private String minimumEngineVersion;
        private ACLPendingChanges pendingChanges;
        private List<String> clusters = DefaultSdkAutoConstructList.getInstance();
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ACL model) {
            this.name(model.name);
            this.status(model.status);
            this.userNames(model.userNames);
            this.minimumEngineVersion(model.minimumEngineVersion);
            this.pendingChanges(model.pendingChanges);
            this.clusters(model.clusters);
            this.arn(model.arn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Collection<String> getUserNames() {
            if (this.userNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userNames;
        }

        public final void setUserNames(Collection<String> userNames) {
            this.userNames = UserNameListCopier.copy(userNames);
        }

        @Override
        @Transient
        public final Builder userNames(Collection<String> userNames) {
            this.userNames = UserNameListCopier.copy(userNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userNames(String ... userNames) {
            this.userNames(Arrays.asList(userNames));
            return this;
        }

        public final String getMinimumEngineVersion() {
            return this.minimumEngineVersion;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        @Override
        @Transient
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public final ACLPendingChanges.Builder getPendingChanges() {
            return this.pendingChanges != null ? this.pendingChanges.toBuilder() : null;
        }

        public final void setPendingChanges(ACLPendingChanges.BuilderImpl pendingChanges) {
            this.pendingChanges = pendingChanges != null ? pendingChanges.build() : null;
        }

        @Override
        @Transient
        public final Builder pendingChanges(ACLPendingChanges pendingChanges) {
            this.pendingChanges = pendingChanges;
            return this;
        }

        public final Collection<String> getClusters() {
            if (this.clusters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clusters;
        }

        public final void setClusters(Collection<String> clusters) {
            this.clusters = ACLClusterNameListCopier.copy(clusters);
        }

        @Override
        @Transient
        public final Builder clusters(Collection<String> clusters) {
            this.clusters = ACLClusterNameListCopier.copy(clusters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusters(String ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public ACL build() {
            return new ACL(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ACL> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder userNames(Collection<String> var1);

        public Builder userNames(String ... var1);

        public Builder minimumEngineVersion(String var1);

        public Builder pendingChanges(ACLPendingChanges var1);

        default public Builder pendingChanges(Consumer<ACLPendingChanges.Builder> pendingChanges) {
            return this.pendingChanges((ACLPendingChanges)((ACLPendingChanges.Builder)ACLPendingChanges.builder().applyMutation(pendingChanges)).build());
        }

        public Builder clusters(Collection<String> var1);

        public Builder clusters(String ... var1);

        public Builder arn(String var1);
    }
}

