/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashConfiguration> {
    private static final SdkField<String> MANIFEST_ENDPOINT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashConfiguration.getter(DashConfiguration::manifestEndpointPrefix)).setter(DashConfiguration.setter(Builder::manifestEndpointPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestEndpointPrefix").build()}).build();
    private static final SdkField<String> MPD_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashConfiguration.getter(DashConfiguration::mpdLocation)).setter(DashConfiguration.setter(Builder::mpdLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MpdLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_ENDPOINT_PREFIX_FIELD, MPD_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String manifestEndpointPrefix;
    private final String mpdLocation;

    private DashConfiguration(BuilderImpl builder) {
        this.manifestEndpointPrefix = builder.manifestEndpointPrefix;
        this.mpdLocation = builder.mpdLocation;
    }

    public String manifestEndpointPrefix() {
        return this.manifestEndpointPrefix;
    }

    public String mpdLocation() {
        return this.mpdLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestEndpointPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpdLocation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashConfiguration)) {
            return false;
        }
        DashConfiguration other = (DashConfiguration)obj;
        return Objects.equals(this.manifestEndpointPrefix(), other.manifestEndpointPrefix()) && Objects.equals(this.mpdLocation(), other.mpdLocation());
    }

    public String toString() {
        return ToString.builder((String)"DashConfiguration").add("ManifestEndpointPrefix", (Object)this.manifestEndpointPrefix()).add("MpdLocation", (Object)this.mpdLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManifestEndpointPrefix": {
                return Optional.ofNullable(clazz.cast(this.manifestEndpointPrefix()));
            }
            case "MpdLocation": {
                return Optional.ofNullable(clazz.cast(this.mpdLocation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashConfiguration, T> g) {
        return obj -> g.apply((DashConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String manifestEndpointPrefix;
        private String mpdLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(DashConfiguration model) {
            this.manifestEndpointPrefix(model.manifestEndpointPrefix);
            this.mpdLocation(model.mpdLocation);
        }

        public final String getManifestEndpointPrefix() {
            return this.manifestEndpointPrefix;
        }

        @Override
        public final Builder manifestEndpointPrefix(String manifestEndpointPrefix) {
            this.manifestEndpointPrefix = manifestEndpointPrefix;
            return this;
        }

        public final void setManifestEndpointPrefix(String manifestEndpointPrefix) {
            this.manifestEndpointPrefix = manifestEndpointPrefix;
        }

        public final String getMpdLocation() {
            return this.mpdLocation;
        }

        @Override
        public final Builder mpdLocation(String mpdLocation) {
            this.mpdLocation = mpdLocation;
            return this;
        }

        public final void setMpdLocation(String mpdLocation) {
            this.mpdLocation = mpdLocation;
        }

        public DashConfiguration build() {
            return new DashConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashConfiguration> {
        public Builder manifestEndpointPrefix(String var1);

        public Builder mpdLocation(String var1);
    }
}

