/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that tells Elemental MediaTailor how to spread out requests to the ad decision server (ADS).
 * Instead of sending ADS requests for all sessions at the same time, MediaTailor spreads the requests across the amount
 * of time specified in the retrieval window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficShapingRetrievalWindow implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficShapingRetrievalWindow.Builder, TrafficShapingRetrievalWindow> {
    private static final SdkField<Integer> RETRIEVAL_WINDOW_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetrievalWindowDurationSeconds")
            .getter(getter(TrafficShapingRetrievalWindow::retrievalWindowDurationSeconds))
            .setter(setter(Builder::retrievalWindowDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalWindowDurationSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RETRIEVAL_WINDOW_DURATION_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer retrievalWindowDurationSeconds;

    private TrafficShapingRetrievalWindow(BuilderImpl builder) {
        this.retrievalWindowDurationSeconds = builder.retrievalWindowDurationSeconds;
    }

    /**
     * <p>
     * The amount of time, in seconds, that MediaTailor spreads prefetch requests to the ADS.
     * </p>
     * 
     * @return The amount of time, in seconds, that MediaTailor spreads prefetch requests to the ADS.
     */
    public final Integer retrievalWindowDurationSeconds() {
        return retrievalWindowDurationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retrievalWindowDurationSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficShapingRetrievalWindow)) {
            return false;
        }
        TrafficShapingRetrievalWindow other = (TrafficShapingRetrievalWindow) obj;
        return Objects.equals(retrievalWindowDurationSeconds(), other.retrievalWindowDurationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficShapingRetrievalWindow")
                .add("RetrievalWindowDurationSeconds", retrievalWindowDurationSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetrievalWindowDurationSeconds":
            return Optional.ofNullable(clazz.cast(retrievalWindowDurationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RetrievalWindowDurationSeconds", RETRIEVAL_WINDOW_DURATION_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrafficShapingRetrievalWindow, T> g) {
        return obj -> g.apply((TrafficShapingRetrievalWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficShapingRetrievalWindow> {
        /**
         * <p>
         * The amount of time, in seconds, that MediaTailor spreads prefetch requests to the ADS.
         * </p>
         * 
         * @param retrievalWindowDurationSeconds
         *        The amount of time, in seconds, that MediaTailor spreads prefetch requests to the ADS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalWindowDurationSeconds(Integer retrievalWindowDurationSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer retrievalWindowDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficShapingRetrievalWindow model) {
            retrievalWindowDurationSeconds(model.retrievalWindowDurationSeconds);
        }

        public final Integer getRetrievalWindowDurationSeconds() {
            return retrievalWindowDurationSeconds;
        }

        public final void setRetrievalWindowDurationSeconds(Integer retrievalWindowDurationSeconds) {
            this.retrievalWindowDurationSeconds = retrievalWindowDurationSeconds;
        }

        @Override
        public final Builder retrievalWindowDurationSeconds(Integer retrievalWindowDurationSeconds) {
            this.retrievalWindowDurationSeconds = retrievalWindowDurationSeconds;
            return this;
        }

        @Override
        public TrafficShapingRetrievalWindow build() {
            return new TrafficShapingRetrievalWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
