/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>segmentation_descriptor</code> message can contain advanced metadata fields, like content identifiers, to
 * convey a wide range of information about the ad break. MediaTailor writes the ad metadata in the egress manifest as
 * part of the <code>EXT-X-DATERANGE</code> or <code>EventStream</code> ad marker's SCTE-35 data.
 * </p>
 * <p>
 * <code>segmentation_descriptor</code> messages must be sent with the <code>time_signal</code> message type.
 * </p>
 * <p>
 * See the <code>segmentation_descriptor()</code> table of the 2022 SCTE-35 specification for more information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentationDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<SegmentationDescriptor.Builder, SegmentationDescriptor> {
    private static final SdkField<Integer> SEGMENTATION_EVENT_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentationEventId").getter(getter(SegmentationDescriptor::segmentationEventId))
            .setter(setter(Builder::segmentationEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentationEventId").build())
            .build();

    private static final SdkField<Integer> SEGMENTATION_UPID_TYPE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentationUpidType").getter(getter(SegmentationDescriptor::segmentationUpidType))
            .setter(setter(Builder::segmentationUpidType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentationUpidType").build())
            .build();

    private static final SdkField<String> SEGMENTATION_UPID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentationUpid").getter(getter(SegmentationDescriptor::segmentationUpid))
            .setter(setter(Builder::segmentationUpid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentationUpid").build()).build();

    private static final SdkField<Integer> SEGMENTATION_TYPE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentationTypeId").getter(getter(SegmentationDescriptor::segmentationTypeId))
            .setter(setter(Builder::segmentationTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentationTypeId").build())
            .build();

    private static final SdkField<Integer> SEGMENT_NUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentNum").getter(getter(SegmentationDescriptor::segmentNum)).setter(setter(Builder::segmentNum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentNum").build()).build();

    private static final SdkField<Integer> SEGMENTS_EXPECTED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentsExpected").getter(getter(SegmentationDescriptor::segmentsExpected))
            .setter(setter(Builder::segmentsExpected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentsExpected").build()).build();

    private static final SdkField<Integer> SUB_SEGMENT_NUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SubSegmentNum").getter(getter(SegmentationDescriptor::subSegmentNum))
            .setter(setter(Builder::subSegmentNum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubSegmentNum").build()).build();

    private static final SdkField<Integer> SUB_SEGMENTS_EXPECTED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SubSegmentsExpected").getter(getter(SegmentationDescriptor::subSegmentsExpected))
            .setter(setter(Builder::subSegmentsExpected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubSegmentsExpected").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENTATION_EVENT_ID_FIELD,
            SEGMENTATION_UPID_TYPE_FIELD, SEGMENTATION_UPID_FIELD, SEGMENTATION_TYPE_ID_FIELD, SEGMENT_NUM_FIELD,
            SEGMENTS_EXPECTED_FIELD, SUB_SEGMENT_NUM_FIELD, SUB_SEGMENTS_EXPECTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer segmentationEventId;

    private final Integer segmentationUpidType;

    private final String segmentationUpid;

    private final Integer segmentationTypeId;

    private final Integer segmentNum;

    private final Integer segmentsExpected;

    private final Integer subSegmentNum;

    private final Integer subSegmentsExpected;

    private SegmentationDescriptor(BuilderImpl builder) {
        this.segmentationEventId = builder.segmentationEventId;
        this.segmentationUpidType = builder.segmentationUpidType;
        this.segmentationUpid = builder.segmentationUpid;
        this.segmentationTypeId = builder.segmentationTypeId;
        this.segmentNum = builder.segmentNum;
        this.segmentsExpected = builder.segmentsExpected;
        this.subSegmentNum = builder.subSegmentNum;
        this.subSegmentsExpected = builder.subSegmentsExpected;
    }

    /**
     * <p>
     * The Event Identifier to assign to the <code>segmentation_descriptor.segmentation_event_id</code> message, as
     * defined in section 10.3.3.1 of the 2022 SCTE-35 specification. The default value is 1.
     * </p>
     * 
     * @return The Event Identifier to assign to the <code>segmentation_descriptor.segmentation_event_id</code> message,
     *         as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. The default value is 1.
     */
    public final Integer segmentationEventId() {
        return segmentationEventId;
    }

    /**
     * <p>
     * The Upid Type to assign to the <code>segmentation_descriptor.segmentation_upid_type</code> message, as defined in
     * section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default
     * value is 14.
     * </p>
     * 
     * @return The Upid Type to assign to the <code>segmentation_descriptor.segmentation_upid_type</code> message, as
     *         defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256,
     *         inclusive. The default value is 14.
     */
    public final Integer segmentationUpidType() {
        return segmentationUpidType;
    }

    /**
     * <p>
     * The Upid to assign to the <code>segmentation_descriptor.segmentation_upid</code> message, as defined in section
     * 10.3.3.1 of the 2022 SCTE-35 specification. The value must be a hexadecimal string containing only the characters
     * 0 though 9 and A through F. The default value is "" (an empty string).
     * </p>
     * 
     * @return The Upid to assign to the <code>segmentation_descriptor.segmentation_upid</code> message, as defined in
     *         section 10.3.3.1 of the 2022 SCTE-35 specification. The value must be a hexadecimal string containing
     *         only the characters 0 though 9 and A through F. The default value is "" (an empty string).
     */
    public final String segmentationUpid() {
        return segmentationUpid;
    }

    /**
     * <p>
     * The Type Identifier to assign to the <code>segmentation_descriptor.segmentation_type_id</code> message, as
     * defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The
     * default value is 48.
     * </p>
     * 
     * @return The Type Identifier to assign to the <code>segmentation_descriptor.segmentation_type_id</code> message,
     *         as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256,
     *         inclusive. The default value is 48.
     */
    public final Integer segmentationTypeId() {
        return segmentationTypeId;
    }

    /**
     * <p>
     * The segment number to assign to the <code>segmentation_descriptor.segment_num</code> message, as defined in
     * section 10.3.3.1 of the 2022 SCTE-35 specification Values must be between 0 and 256, inclusive. The default value
     * is 0.
     * </p>
     * 
     * @return The segment number to assign to the <code>segmentation_descriptor.segment_num</code> message, as defined
     *         in section 10.3.3.1 of the 2022 SCTE-35 specification Values must be between 0 and 256, inclusive. The
     *         default value is 0.
     */
    public final Integer segmentNum() {
        return segmentNum;
    }

    /**
     * <p>
     * The number of segments expected, which is assigned to the <code>segmentation_descriptor.segments_expectedS</code>
     * message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification Values must be between 0 and 256,
     * inclusive. The default value is 0.
     * </p>
     * 
     * @return The number of segments expected, which is assigned to the
     *         <code>segmentation_descriptor.segments_expectedS</code> message, as defined in section 10.3.3.1 of the
     *         2022 SCTE-35 specification Values must be between 0 and 256, inclusive. The default value is 0.
     */
    public final Integer segmentsExpected() {
        return segmentsExpected;
    }

    /**
     * <p>
     * The sub-segment number to assign to the <code>segmentation_descriptor.sub_segment_num</code> message, as defined
     * in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The defualt
     * value is null.
     * </p>
     * 
     * @return The sub-segment number to assign to the <code>segmentation_descriptor.sub_segment_num</code> message, as
     *         defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256,
     *         inclusive. The defualt value is null.
     */
    public final Integer subSegmentNum() {
        return subSegmentNum;
    }

    /**
     * <p>
     * The number of sub-segments expected, which is assigned to the
     * <code>segmentation_descriptor.sub_segments_expected</code> message, as defined in section 10.3.3.1 of the 2022
     * SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is null.
     * </p>
     * 
     * @return The number of sub-segments expected, which is assigned to the
     *         <code>segmentation_descriptor.sub_segments_expected</code> message, as defined in section 10.3.3.1 of the
     *         2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is null.
     */
    public final Integer subSegmentsExpected() {
        return subSegmentsExpected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(segmentationEventId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationUpidType());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationUpid());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentNum());
        hashCode = 31 * hashCode + Objects.hashCode(segmentsExpected());
        hashCode = 31 * hashCode + Objects.hashCode(subSegmentNum());
        hashCode = 31 * hashCode + Objects.hashCode(subSegmentsExpected());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentationDescriptor)) {
            return false;
        }
        SegmentationDescriptor other = (SegmentationDescriptor) obj;
        return Objects.equals(segmentationEventId(), other.segmentationEventId())
                && Objects.equals(segmentationUpidType(), other.segmentationUpidType())
                && Objects.equals(segmentationUpid(), other.segmentationUpid())
                && Objects.equals(segmentationTypeId(), other.segmentationTypeId())
                && Objects.equals(segmentNum(), other.segmentNum())
                && Objects.equals(segmentsExpected(), other.segmentsExpected())
                && Objects.equals(subSegmentNum(), other.subSegmentNum())
                && Objects.equals(subSegmentsExpected(), other.subSegmentsExpected());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SegmentationDescriptor").add("SegmentationEventId", segmentationEventId())
                .add("SegmentationUpidType", segmentationUpidType()).add("SegmentationUpid", segmentationUpid())
                .add("SegmentationTypeId", segmentationTypeId()).add("SegmentNum", segmentNum())
                .add("SegmentsExpected", segmentsExpected()).add("SubSegmentNum", subSegmentNum())
                .add("SubSegmentsExpected", subSegmentsExpected()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SegmentationEventId":
            return Optional.ofNullable(clazz.cast(segmentationEventId()));
        case "SegmentationUpidType":
            return Optional.ofNullable(clazz.cast(segmentationUpidType()));
        case "SegmentationUpid":
            return Optional.ofNullable(clazz.cast(segmentationUpid()));
        case "SegmentationTypeId":
            return Optional.ofNullable(clazz.cast(segmentationTypeId()));
        case "SegmentNum":
            return Optional.ofNullable(clazz.cast(segmentNum()));
        case "SegmentsExpected":
            return Optional.ofNullable(clazz.cast(segmentsExpected()));
        case "SubSegmentNum":
            return Optional.ofNullable(clazz.cast(subSegmentNum()));
        case "SubSegmentsExpected":
            return Optional.ofNullable(clazz.cast(subSegmentsExpected()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SegmentationEventId", SEGMENTATION_EVENT_ID_FIELD);
        map.put("SegmentationUpidType", SEGMENTATION_UPID_TYPE_FIELD);
        map.put("SegmentationUpid", SEGMENTATION_UPID_FIELD);
        map.put("SegmentationTypeId", SEGMENTATION_TYPE_ID_FIELD);
        map.put("SegmentNum", SEGMENT_NUM_FIELD);
        map.put("SegmentsExpected", SEGMENTS_EXPECTED_FIELD);
        map.put("SubSegmentNum", SUB_SEGMENT_NUM_FIELD);
        map.put("SubSegmentsExpected", SUB_SEGMENTS_EXPECTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SegmentationDescriptor, T> g) {
        return obj -> g.apply((SegmentationDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentationDescriptor> {
        /**
         * <p>
         * The Event Identifier to assign to the <code>segmentation_descriptor.segmentation_event_id</code> message, as
         * defined in section 10.3.3.1 of the 2022 SCTE-35 specification. The default value is 1.
         * </p>
         * 
         * @param segmentationEventId
         *        The Event Identifier to assign to the <code>segmentation_descriptor.segmentation_event_id</code>
         *        message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. The default value is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationEventId(Integer segmentationEventId);

        /**
         * <p>
         * The Upid Type to assign to the <code>segmentation_descriptor.segmentation_upid_type</code> message, as
         * defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive.
         * The default value is 14.
         * </p>
         * 
         * @param segmentationUpidType
         *        The Upid Type to assign to the <code>segmentation_descriptor.segmentation_upid_type</code> message, as
         *        defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256,
         *        inclusive. The default value is 14.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationUpidType(Integer segmentationUpidType);

        /**
         * <p>
         * The Upid to assign to the <code>segmentation_descriptor.segmentation_upid</code> message, as defined in
         * section 10.3.3.1 of the 2022 SCTE-35 specification. The value must be a hexadecimal string containing only
         * the characters 0 though 9 and A through F. The default value is "" (an empty string).
         * </p>
         * 
         * @param segmentationUpid
         *        The Upid to assign to the <code>segmentation_descriptor.segmentation_upid</code> message, as defined
         *        in section 10.3.3.1 of the 2022 SCTE-35 specification. The value must be a hexadecimal string
         *        containing only the characters 0 though 9 and A through F. The default value is "" (an empty string).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationUpid(String segmentationUpid);

        /**
         * <p>
         * The Type Identifier to assign to the <code>segmentation_descriptor.segmentation_type_id</code> message, as
         * defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive.
         * The default value is 48.
         * </p>
         * 
         * @param segmentationTypeId
         *        The Type Identifier to assign to the <code>segmentation_descriptor.segmentation_type_id</code>
         *        message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0
         *        and 256, inclusive. The default value is 48.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationTypeId(Integer segmentationTypeId);

        /**
         * <p>
         * The segment number to assign to the <code>segmentation_descriptor.segment_num</code> message, as defined in
         * section 10.3.3.1 of the 2022 SCTE-35 specification Values must be between 0 and 256, inclusive. The default
         * value is 0.
         * </p>
         * 
         * @param segmentNum
         *        The segment number to assign to the <code>segmentation_descriptor.segment_num</code> message, as
         *        defined in section 10.3.3.1 of the 2022 SCTE-35 specification Values must be between 0 and 256,
         *        inclusive. The default value is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentNum(Integer segmentNum);

        /**
         * <p>
         * The number of segments expected, which is assigned to the
         * <code>segmentation_descriptor.segments_expectedS</code> message, as defined in section 10.3.3.1 of the 2022
         * SCTE-35 specification Values must be between 0 and 256, inclusive. The default value is 0.
         * </p>
         * 
         * @param segmentsExpected
         *        The number of segments expected, which is assigned to the
         *        <code>segmentation_descriptor.segments_expectedS</code> message, as defined in section 10.3.3.1 of the
         *        2022 SCTE-35 specification Values must be between 0 and 256, inclusive. The default value is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentsExpected(Integer segmentsExpected);

        /**
         * <p>
         * The sub-segment number to assign to the <code>segmentation_descriptor.sub_segment_num</code> message, as
         * defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive.
         * The defualt value is null.
         * </p>
         * 
         * @param subSegmentNum
         *        The sub-segment number to assign to the <code>segmentation_descriptor.sub_segment_num</code> message,
         *        as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256,
         *        inclusive. The defualt value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subSegmentNum(Integer subSegmentNum);

        /**
         * <p>
         * The number of sub-segments expected, which is assigned to the
         * <code>segmentation_descriptor.sub_segments_expected</code> message, as defined in section 10.3.3.1 of the
         * 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is null.
         * </p>
         * 
         * @param subSegmentsExpected
         *        The number of sub-segments expected, which is assigned to the
         *        <code>segmentation_descriptor.sub_segments_expected</code> message, as defined in section 10.3.3.1 of
         *        the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subSegmentsExpected(Integer subSegmentsExpected);
    }

    static final class BuilderImpl implements Builder {
        private Integer segmentationEventId;

        private Integer segmentationUpidType;

        private String segmentationUpid;

        private Integer segmentationTypeId;

        private Integer segmentNum;

        private Integer segmentsExpected;

        private Integer subSegmentNum;

        private Integer subSegmentsExpected;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentationDescriptor model) {
            segmentationEventId(model.segmentationEventId);
            segmentationUpidType(model.segmentationUpidType);
            segmentationUpid(model.segmentationUpid);
            segmentationTypeId(model.segmentationTypeId);
            segmentNum(model.segmentNum);
            segmentsExpected(model.segmentsExpected);
            subSegmentNum(model.subSegmentNum);
            subSegmentsExpected(model.subSegmentsExpected);
        }

        public final Integer getSegmentationEventId() {
            return segmentationEventId;
        }

        public final void setSegmentationEventId(Integer segmentationEventId) {
            this.segmentationEventId = segmentationEventId;
        }

        @Override
        public final Builder segmentationEventId(Integer segmentationEventId) {
            this.segmentationEventId = segmentationEventId;
            return this;
        }

        public final Integer getSegmentationUpidType() {
            return segmentationUpidType;
        }

        public final void setSegmentationUpidType(Integer segmentationUpidType) {
            this.segmentationUpidType = segmentationUpidType;
        }

        @Override
        public final Builder segmentationUpidType(Integer segmentationUpidType) {
            this.segmentationUpidType = segmentationUpidType;
            return this;
        }

        public final String getSegmentationUpid() {
            return segmentationUpid;
        }

        public final void setSegmentationUpid(String segmentationUpid) {
            this.segmentationUpid = segmentationUpid;
        }

        @Override
        public final Builder segmentationUpid(String segmentationUpid) {
            this.segmentationUpid = segmentationUpid;
            return this;
        }

        public final Integer getSegmentationTypeId() {
            return segmentationTypeId;
        }

        public final void setSegmentationTypeId(Integer segmentationTypeId) {
            this.segmentationTypeId = segmentationTypeId;
        }

        @Override
        public final Builder segmentationTypeId(Integer segmentationTypeId) {
            this.segmentationTypeId = segmentationTypeId;
            return this;
        }

        public final Integer getSegmentNum() {
            return segmentNum;
        }

        public final void setSegmentNum(Integer segmentNum) {
            this.segmentNum = segmentNum;
        }

        @Override
        public final Builder segmentNum(Integer segmentNum) {
            this.segmentNum = segmentNum;
            return this;
        }

        public final Integer getSegmentsExpected() {
            return segmentsExpected;
        }

        public final void setSegmentsExpected(Integer segmentsExpected) {
            this.segmentsExpected = segmentsExpected;
        }

        @Override
        public final Builder segmentsExpected(Integer segmentsExpected) {
            this.segmentsExpected = segmentsExpected;
            return this;
        }

        public final Integer getSubSegmentNum() {
            return subSegmentNum;
        }

        public final void setSubSegmentNum(Integer subSegmentNum) {
            this.subSegmentNum = subSegmentNum;
        }

        @Override
        public final Builder subSegmentNum(Integer subSegmentNum) {
            this.subSegmentNum = subSegmentNum;
            return this;
        }

        public final Integer getSubSegmentsExpected() {
            return subSegmentsExpected;
        }

        public final void setSubSegmentsExpected(Integer subSegmentsExpected) {
            this.subSegmentsExpected = subSegmentsExpected;
        }

        @Override
        public final Builder subSegmentsExpected(Integer subSegmentsExpected) {
            this.subSegmentsExpected = subSegmentsExpected;
            return this;
        }

        @Override
        public SegmentationDescriptor build() {
            return new SegmentationDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
