/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for customizing what events are included in logs for interactions with the origin server.
 * </p>
 * <p>
 * For more information about manifest service logs, including descriptions of the event types, see <a
 * href="https://docs.aws.amazon.com/mediatailor/latest/ug/log-types.html">MediaTailor manifest logs description and
 * event types</a> in Elemental MediaTailor User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManifestServiceInteractionLog implements SdkPojo, Serializable,
        ToCopyableBuilder<ManifestServiceInteractionLog.Builder, ManifestServiceInteractionLog> {
    private static final SdkField<List<String>> EXCLUDE_EVENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludeEventTypes")
            .getter(getter(ManifestServiceInteractionLog::excludeEventTypesAsStrings))
            .setter(setter(Builder::excludeEventTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeEventTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDE_EVENT_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> excludeEventTypes;

    private ManifestServiceInteractionLog(BuilderImpl builder) {
        this.excludeEventTypes = builder.excludeEventTypes;
    }

    /**
     * <p>
     * Indicates that MediaTailor won't emit the selected events in the logs for playback sessions that are initialized
     * with this configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeEventTypes} method.
     * </p>
     * 
     * @return Indicates that MediaTailor won't emit the selected events in the logs for playback sessions that are
     *         initialized with this configuration.
     */
    public final List<ManifestServiceExcludeEventType> excludeEventTypes() {
        return ___manifestServiceExcludeEventTypesListCopier.copyStringToEnum(excludeEventTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeEventTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeEventTypes() {
        return excludeEventTypes != null && !(excludeEventTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates that MediaTailor won't emit the selected events in the logs for playback sessions that are initialized
     * with this configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeEventTypes} method.
     * </p>
     * 
     * @return Indicates that MediaTailor won't emit the selected events in the logs for playback sessions that are
     *         initialized with this configuration.
     */
    public final List<String> excludeEventTypesAsStrings() {
        return excludeEventTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeEventTypes() ? excludeEventTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManifestServiceInteractionLog)) {
            return false;
        }
        ManifestServiceInteractionLog other = (ManifestServiceInteractionLog) obj;
        return hasExcludeEventTypes() == other.hasExcludeEventTypes()
                && Objects.equals(excludeEventTypesAsStrings(), other.excludeEventTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManifestServiceInteractionLog")
                .add("ExcludeEventTypes", hasExcludeEventTypes() ? excludeEventTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExcludeEventTypes":
            return Optional.ofNullable(clazz.cast(excludeEventTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExcludeEventTypes", EXCLUDE_EVENT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManifestServiceInteractionLog, T> g) {
        return obj -> g.apply((ManifestServiceInteractionLog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManifestServiceInteractionLog> {
        /**
         * <p>
         * Indicates that MediaTailor won't emit the selected events in the logs for playback sessions that are
         * initialized with this configuration.
         * </p>
         * 
         * @param excludeEventTypes
         *        Indicates that MediaTailor won't emit the selected events in the logs for playback sessions that are
         *        initialized with this configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeEventTypesWithStrings(Collection<String> excludeEventTypes);

        /**
         * <p>
         * Indicates that MediaTailor won't emit the selected events in the logs for playback sessions that are
         * initialized with this configuration.
         * </p>
         * 
         * @param excludeEventTypes
         *        Indicates that MediaTailor won't emit the selected events in the logs for playback sessions that are
         *        initialized with this configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeEventTypesWithStrings(String... excludeEventTypes);

        /**
         * <p>
         * Indicates that MediaTailor won't emit the selected events in the logs for playback sessions that are
         * initialized with this configuration.
         * </p>
         * 
         * @param excludeEventTypes
         *        Indicates that MediaTailor won't emit the selected events in the logs for playback sessions that are
         *        initialized with this configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeEventTypes(Collection<ManifestServiceExcludeEventType> excludeEventTypes);

        /**
         * <p>
         * Indicates that MediaTailor won't emit the selected events in the logs for playback sessions that are
         * initialized with this configuration.
         * </p>
         * 
         * @param excludeEventTypes
         *        Indicates that MediaTailor won't emit the selected events in the logs for playback sessions that are
         *        initialized with this configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeEventTypes(ManifestServiceExcludeEventType... excludeEventTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> excludeEventTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ManifestServiceInteractionLog model) {
            excludeEventTypesWithStrings(model.excludeEventTypes);
        }

        public final Collection<String> getExcludeEventTypes() {
            if (excludeEventTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeEventTypes;
        }

        public final void setExcludeEventTypes(Collection<String> excludeEventTypes) {
            this.excludeEventTypes = ___manifestServiceExcludeEventTypesListCopier.copy(excludeEventTypes);
        }

        @Override
        public final Builder excludeEventTypesWithStrings(Collection<String> excludeEventTypes) {
            this.excludeEventTypes = ___manifestServiceExcludeEventTypesListCopier.copy(excludeEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeEventTypesWithStrings(String... excludeEventTypes) {
            excludeEventTypesWithStrings(Arrays.asList(excludeEventTypes));
            return this;
        }

        @Override
        public final Builder excludeEventTypes(Collection<ManifestServiceExcludeEventType> excludeEventTypes) {
            this.excludeEventTypes = ___manifestServiceExcludeEventTypesListCopier.copyEnumToString(excludeEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeEventTypes(ManifestServiceExcludeEventType... excludeEventTypes) {
            excludeEventTypes(Arrays.asList(excludeEventTypes));
            return this;
        }

        @Override
        public ManifestServiceInteractionLog build() {
            return new ManifestServiceInteractionLog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
