/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAlertsRequest extends MediaTailorRequest implements
        ToCopyableBuilder<ListAlertsRequest.Builder, ListAlertsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAlertsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAlertsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(ListAlertsRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String resourceArn;

    private ListAlertsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The maximum number of alerts that you want MediaTailor to return in response to the current request. If there are
     * more than <code>MaxResults</code> alerts, use the value of <code>NextToken</code> in the response to get the next
     * page of results.
     * </p>
     * <p>
     * The default value is 100. MediaTailor uses DynamoDB-based pagination, which means that a response might contain
     * fewer than <code>MaxResults</code> items, including 0 items, even when more results are available. To retrieve
     * all results, you must continue making requests using the <code>NextToken</code> value from each response until
     * the response no longer includes a <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of alerts that you want MediaTailor to return in response to the current request. If
     *         there are more than <code>MaxResults</code> alerts, use the value of <code>NextToken</code> in the
     *         response to get the next page of results.</p>
     *         <p>
     *         The default value is 100. MediaTailor uses DynamoDB-based pagination, which means that a response might
     *         contain fewer than <code>MaxResults</code> items, including 0 items, even when more results are
     *         available. To retrieve all results, you must continue making requests using the <code>NextToken</code>
     *         value from each response until the response no longer includes a <code>NextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the
     * next page of results.
     * </p>
     * <p>
     * For the first <code>ListAlerts</code> request, omit this value. For subsequent requests, get the value of
     * <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the
     * request. Continue making requests until the response no longer includes a <code>NextToken</code> value, which
     * indicates that all results have been retrieved.
     * </p>
     * 
     * @return Pagination token returned by the list request when results exceed the maximum allowed. Use the token to
     *         fetch the next page of results.</p>
     *         <p>
     *         For the first <code>ListAlerts</code> request, omit this value. For subsequent requests, get the value of
     *         <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in
     *         the request. Continue making requests until the response no longer includes a <code>NextToken</code>
     *         value, which indicates that all results have been retrieved.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlertsRequest)) {
            return false;
        }
        ListAlertsRequest other = (ListAlertsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAlertsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAlertsRequest, T> g) {
        return obj -> g.apply((ListAlertsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAlertsRequest> {
        /**
         * <p>
         * The maximum number of alerts that you want MediaTailor to return in response to the current request. If there
         * are more than <code>MaxResults</code> alerts, use the value of <code>NextToken</code> in the response to get
         * the next page of results.
         * </p>
         * <p>
         * The default value is 100. MediaTailor uses DynamoDB-based pagination, which means that a response might
         * contain fewer than <code>MaxResults</code> items, including 0 items, even when more results are available. To
         * retrieve all results, you must continue making requests using the <code>NextToken</code> value from each
         * response until the response no longer includes a <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of alerts that you want MediaTailor to return in response to the current request.
         *        If there are more than <code>MaxResults</code> alerts, use the value of <code>NextToken</code> in the
         *        response to get the next page of results.</p>
         *        <p>
         *        The default value is 100. MediaTailor uses DynamoDB-based pagination, which means that a response
         *        might contain fewer than <code>MaxResults</code> items, including 0 items, even when more results are
         *        available. To retrieve all results, you must continue making requests using the <code>NextToken</code>
         *        value from each response until the response no longer includes a <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch
         * the next page of results.
         * </p>
         * <p>
         * For the first <code>ListAlerts</code> request, omit this value. For subsequent requests, get the value of
         * <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the
         * request. Continue making requests until the response no longer includes a <code>NextToken</code> value, which
         * indicates that all results have been retrieved.
         * </p>
         * 
         * @param nextToken
         *        Pagination token returned by the list request when results exceed the maximum allowed. Use the token
         *        to fetch the next page of results.</p>
         *        <p>
         *        For the first <code>ListAlerts</code> request, omit this value. For subsequent requests, get the value
         *        of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code>
         *        in the request. Continue making requests until the response no longer includes a
         *        <code>NextToken</code> value, which indicates that all results have been retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlertsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            resourceArn(model.resourceArn);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAlertsRequest build() {
            return new ListAlertsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
