/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigureLogsForPlaybackConfigurationResponse extends MediaTailorResponse implements
        ToCopyableBuilder<ConfigureLogsForPlaybackConfigurationResponse.Builder, ConfigureLogsForPlaybackConfigurationResponse> {
    private static final SdkField<Integer> PERCENT_ENABLED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PercentEnabled").getter(getter(ConfigureLogsForPlaybackConfigurationResponse::percentEnabled))
            .setter(setter(Builder::percentEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentEnabled").build()).build();

    private static final SdkField<String> PLAYBACK_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaybackConfigurationName")
            .getter(getter(ConfigureLogsForPlaybackConfigurationResponse::playbackConfigurationName))
            .setter(setter(Builder::playbackConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackConfigurationName").build())
            .build();

    private static final SdkField<List<String>> ENABLED_LOGGING_STRATEGIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledLoggingStrategies")
            .getter(getter(ConfigureLogsForPlaybackConfigurationResponse::enabledLoggingStrategiesAsStrings))
            .setter(setter(Builder::enabledLoggingStrategiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledLoggingStrategies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AdsInteractionLog> ADS_INTERACTION_LOG_FIELD = SdkField
            .<AdsInteractionLog> builder(MarshallingType.SDK_POJO).memberName("AdsInteractionLog")
            .getter(getter(ConfigureLogsForPlaybackConfigurationResponse::adsInteractionLog))
            .setter(setter(Builder::adsInteractionLog)).constructor(AdsInteractionLog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdsInteractionLog").build()).build();

    private static final SdkField<ManifestServiceInteractionLog> MANIFEST_SERVICE_INTERACTION_LOG_FIELD = SdkField
            .<ManifestServiceInteractionLog> builder(MarshallingType.SDK_POJO)
            .memberName("ManifestServiceInteractionLog")
            .getter(getter(ConfigureLogsForPlaybackConfigurationResponse::manifestServiceInteractionLog))
            .setter(setter(Builder::manifestServiceInteractionLog))
            .constructor(ManifestServiceInteractionLog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestServiceInteractionLog")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENT_ENABLED_FIELD,
            PLAYBACK_CONFIGURATION_NAME_FIELD, ENABLED_LOGGING_STRATEGIES_FIELD, ADS_INTERACTION_LOG_FIELD,
            MANIFEST_SERVICE_INTERACTION_LOG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer percentEnabled;

    private final String playbackConfigurationName;

    private final List<String> enabledLoggingStrategies;

    private final AdsInteractionLog adsInteractionLog;

    private final ManifestServiceInteractionLog manifestServiceInteractionLog;

    private ConfigureLogsForPlaybackConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.percentEnabled = builder.percentEnabled;
        this.playbackConfigurationName = builder.playbackConfigurationName;
        this.enabledLoggingStrategies = builder.enabledLoggingStrategies;
        this.adsInteractionLog = builder.adsInteractionLog;
        this.manifestServiceInteractionLog = builder.manifestServiceInteractionLog;
    }

    /**
     * <p>
     * The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account.
     * </p>
     * 
     * @return The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account.
     */
    public final Integer percentEnabled() {
        return percentEnabled;
    }

    /**
     * <p>
     * The name of the playback configuration.
     * </p>
     * 
     * @return The name of the playback configuration.
     */
    public final String playbackConfigurationName() {
        return playbackConfigurationName;
    }

    /**
     * <p>
     * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates that
     * MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
     * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
     * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledLoggingStrategies} method.
     * </p>
     * 
     * @return The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
     *         indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code>
     *         indicates that MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination
     *         of choice. Supported destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data
     *         Firehose stream.
     */
    public final List<LoggingStrategy> enabledLoggingStrategies() {
        return ___listOfLoggingStrategiesCopier.copyStringToEnum(enabledLoggingStrategies);
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledLoggingStrategies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnabledLoggingStrategies() {
        return enabledLoggingStrategies != null && !(enabledLoggingStrategies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates that
     * MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
     * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
     * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledLoggingStrategies} method.
     * </p>
     * 
     * @return The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
     *         indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code>
     *         indicates that MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination
     *         of choice. Supported destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data
     *         Firehose stream.
     */
    public final List<String> enabledLoggingStrategiesAsStrings() {
        return enabledLoggingStrategies;
    }

    /**
     * <p>
     * The event types that MediaTailor emits in logs for interactions with the ADS.
     * </p>
     * 
     * @return The event types that MediaTailor emits in logs for interactions with the ADS.
     */
    public final AdsInteractionLog adsInteractionLog() {
        return adsInteractionLog;
    }

    /**
     * <p>
     * The event types that MediaTailor emits in logs for interactions with the origin server.
     * </p>
     * 
     * @return The event types that MediaTailor emits in logs for interactions with the origin server.
     */
    public final ManifestServiceInteractionLog manifestServiceInteractionLog() {
        return manifestServiceInteractionLog;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(percentEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(playbackConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledLoggingStrategies() ? enabledLoggingStrategiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(adsInteractionLog());
        hashCode = 31 * hashCode + Objects.hashCode(manifestServiceInteractionLog());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureLogsForPlaybackConfigurationResponse)) {
            return false;
        }
        ConfigureLogsForPlaybackConfigurationResponse other = (ConfigureLogsForPlaybackConfigurationResponse) obj;
        return Objects.equals(percentEnabled(), other.percentEnabled())
                && Objects.equals(playbackConfigurationName(), other.playbackConfigurationName())
                && hasEnabledLoggingStrategies() == other.hasEnabledLoggingStrategies()
                && Objects.equals(enabledLoggingStrategiesAsStrings(), other.enabledLoggingStrategiesAsStrings())
                && Objects.equals(adsInteractionLog(), other.adsInteractionLog())
                && Objects.equals(manifestServiceInteractionLog(), other.manifestServiceInteractionLog());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigureLogsForPlaybackConfigurationResponse").add("PercentEnabled", percentEnabled())
                .add("PlaybackConfigurationName", playbackConfigurationName())
                .add("EnabledLoggingStrategies", hasEnabledLoggingStrategies() ? enabledLoggingStrategiesAsStrings() : null)
                .add("AdsInteractionLog", adsInteractionLog())
                .add("ManifestServiceInteractionLog", manifestServiceInteractionLog()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PercentEnabled":
            return Optional.ofNullable(clazz.cast(percentEnabled()));
        case "PlaybackConfigurationName":
            return Optional.ofNullable(clazz.cast(playbackConfigurationName()));
        case "EnabledLoggingStrategies":
            return Optional.ofNullable(clazz.cast(enabledLoggingStrategiesAsStrings()));
        case "AdsInteractionLog":
            return Optional.ofNullable(clazz.cast(adsInteractionLog()));
        case "ManifestServiceInteractionLog":
            return Optional.ofNullable(clazz.cast(manifestServiceInteractionLog()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PercentEnabled", PERCENT_ENABLED_FIELD);
        map.put("PlaybackConfigurationName", PLAYBACK_CONFIGURATION_NAME_FIELD);
        map.put("EnabledLoggingStrategies", ENABLED_LOGGING_STRATEGIES_FIELD);
        map.put("AdsInteractionLog", ADS_INTERACTION_LOG_FIELD);
        map.put("ManifestServiceInteractionLog", MANIFEST_SERVICE_INTERACTION_LOG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigureLogsForPlaybackConfigurationResponse, T> g) {
        return obj -> g.apply((ConfigureLogsForPlaybackConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaTailorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ConfigureLogsForPlaybackConfigurationResponse> {
        /**
         * <p>
         * The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account.
         * </p>
         * 
         * @param percentEnabled
         *        The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentEnabled(Integer percentEnabled);

        /**
         * <p>
         * The name of the playback configuration.
         * </p>
         * 
         * @param playbackConfigurationName
         *        The name of the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackConfigurationName(String playbackConfigurationName);

        /**
         * <p>
         * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates
         * that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
         * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
         * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         * </p>
         * 
         * @param enabledLoggingStrategies
         *        The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
         *        indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs.
         *        <code>VENDED_LOGS</code> indicates that MediaTailor is sending logs to CloudWatch, which then vends
         *        the logs to your destination of choice. Supported destinations are CloudWatch Logs log group, Amazon
         *        S3 bucket, and Amazon Data Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledLoggingStrategiesWithStrings(Collection<String> enabledLoggingStrategies);

        /**
         * <p>
         * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates
         * that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
         * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
         * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         * </p>
         * 
         * @param enabledLoggingStrategies
         *        The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
         *        indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs.
         *        <code>VENDED_LOGS</code> indicates that MediaTailor is sending logs to CloudWatch, which then vends
         *        the logs to your destination of choice. Supported destinations are CloudWatch Logs log group, Amazon
         *        S3 bucket, and Amazon Data Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledLoggingStrategiesWithStrings(String... enabledLoggingStrategies);

        /**
         * <p>
         * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates
         * that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
         * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
         * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         * </p>
         * 
         * @param enabledLoggingStrategies
         *        The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
         *        indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs.
         *        <code>VENDED_LOGS</code> indicates that MediaTailor is sending logs to CloudWatch, which then vends
         *        the logs to your destination of choice. Supported destinations are CloudWatch Logs log group, Amazon
         *        S3 bucket, and Amazon Data Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledLoggingStrategies(Collection<LoggingStrategy> enabledLoggingStrategies);

        /**
         * <p>
         * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates
         * that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
         * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
         * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         * </p>
         * 
         * @param enabledLoggingStrategies
         *        The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
         *        indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs.
         *        <code>VENDED_LOGS</code> indicates that MediaTailor is sending logs to CloudWatch, which then vends
         *        the logs to your destination of choice. Supported destinations are CloudWatch Logs log group, Amazon
         *        S3 bucket, and Amazon Data Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledLoggingStrategies(LoggingStrategy... enabledLoggingStrategies);

        /**
         * <p>
         * The event types that MediaTailor emits in logs for interactions with the ADS.
         * </p>
         * 
         * @param adsInteractionLog
         *        The event types that MediaTailor emits in logs for interactions with the ADS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adsInteractionLog(AdsInteractionLog adsInteractionLog);

        /**
         * <p>
         * The event types that MediaTailor emits in logs for interactions with the ADS.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdsInteractionLog.Builder} avoiding the
         * need to create one manually via {@link AdsInteractionLog#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdsInteractionLog.Builder#build()} is called immediately and its
         * result is passed to {@link #adsInteractionLog(AdsInteractionLog)}.
         * 
         * @param adsInteractionLog
         *        a consumer that will call methods on {@link AdsInteractionLog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adsInteractionLog(AdsInteractionLog)
         */
        default Builder adsInteractionLog(Consumer<AdsInteractionLog.Builder> adsInteractionLog) {
            return adsInteractionLog(AdsInteractionLog.builder().applyMutation(adsInteractionLog).build());
        }

        /**
         * <p>
         * The event types that MediaTailor emits in logs for interactions with the origin server.
         * </p>
         * 
         * @param manifestServiceInteractionLog
         *        The event types that MediaTailor emits in logs for interactions with the origin server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestServiceInteractionLog(ManifestServiceInteractionLog manifestServiceInteractionLog);

        /**
         * <p>
         * The event types that MediaTailor emits in logs for interactions with the origin server.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManifestServiceInteractionLog.Builder}
         * avoiding the need to create one manually via {@link ManifestServiceInteractionLog#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManifestServiceInteractionLog.Builder#build()} is called
         * immediately and its result is passed to {@link #manifestServiceInteractionLog(ManifestServiceInteractionLog)}.
         * 
         * @param manifestServiceInteractionLog
         *        a consumer that will call methods on {@link ManifestServiceInteractionLog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestServiceInteractionLog(ManifestServiceInteractionLog)
         */
        default Builder manifestServiceInteractionLog(
                Consumer<ManifestServiceInteractionLog.Builder> manifestServiceInteractionLog) {
            return manifestServiceInteractionLog(ManifestServiceInteractionLog.builder()
                    .applyMutation(manifestServiceInteractionLog).build());
        }
    }

    static final class BuilderImpl extends MediaTailorResponse.BuilderImpl implements Builder {
        private Integer percentEnabled;

        private String playbackConfigurationName;

        private List<String> enabledLoggingStrategies = DefaultSdkAutoConstructList.getInstance();

        private AdsInteractionLog adsInteractionLog;

        private ManifestServiceInteractionLog manifestServiceInteractionLog;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureLogsForPlaybackConfigurationResponse model) {
            super(model);
            percentEnabled(model.percentEnabled);
            playbackConfigurationName(model.playbackConfigurationName);
            enabledLoggingStrategiesWithStrings(model.enabledLoggingStrategies);
            adsInteractionLog(model.adsInteractionLog);
            manifestServiceInteractionLog(model.manifestServiceInteractionLog);
        }

        public final Integer getPercentEnabled() {
            return percentEnabled;
        }

        public final void setPercentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
        }

        @Override
        public final Builder percentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
            return this;
        }

        public final String getPlaybackConfigurationName() {
            return playbackConfigurationName;
        }

        public final void setPlaybackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
        }

        @Override
        public final Builder playbackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
            return this;
        }

        public final Collection<String> getEnabledLoggingStrategies() {
            if (enabledLoggingStrategies instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledLoggingStrategies;
        }

        public final void setEnabledLoggingStrategies(Collection<String> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copy(enabledLoggingStrategies);
        }

        @Override
        public final Builder enabledLoggingStrategiesWithStrings(Collection<String> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copy(enabledLoggingStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledLoggingStrategiesWithStrings(String... enabledLoggingStrategies) {
            enabledLoggingStrategiesWithStrings(Arrays.asList(enabledLoggingStrategies));
            return this;
        }

        @Override
        public final Builder enabledLoggingStrategies(Collection<LoggingStrategy> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copyEnumToString(enabledLoggingStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledLoggingStrategies(LoggingStrategy... enabledLoggingStrategies) {
            enabledLoggingStrategies(Arrays.asList(enabledLoggingStrategies));
            return this;
        }

        public final AdsInteractionLog.Builder getAdsInteractionLog() {
            return adsInteractionLog != null ? adsInteractionLog.toBuilder() : null;
        }

        public final void setAdsInteractionLog(AdsInteractionLog.BuilderImpl adsInteractionLog) {
            this.adsInteractionLog = adsInteractionLog != null ? adsInteractionLog.build() : null;
        }

        @Override
        public final Builder adsInteractionLog(AdsInteractionLog adsInteractionLog) {
            this.adsInteractionLog = adsInteractionLog;
            return this;
        }

        public final ManifestServiceInteractionLog.Builder getManifestServiceInteractionLog() {
            return manifestServiceInteractionLog != null ? manifestServiceInteractionLog.toBuilder() : null;
        }

        public final void setManifestServiceInteractionLog(ManifestServiceInteractionLog.BuilderImpl manifestServiceInteractionLog) {
            this.manifestServiceInteractionLog = manifestServiceInteractionLog != null ? manifestServiceInteractionLog.build()
                    : null;
        }

        @Override
        public final Builder manifestServiceInteractionLog(ManifestServiceInteractionLog manifestServiceInteractionLog) {
            this.manifestServiceInteractionLog = manifestServiceInteractionLog;
            return this;
        }

        @Override
        public ConfigureLogsForPlaybackConfigurationResponse build() {
            return new ConfigureLogsForPlaybackConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
