/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.LoggingStrategy;
import software.amazon.awssdk.services.mediatailor.model.___listOfLoggingStrategiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogConfiguration> {
    private static final SdkField<Integer> PERCENT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PercentEnabled").getter(LogConfiguration.getter(LogConfiguration::percentEnabled)).setter(LogConfiguration.setter(Builder::percentEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentEnabled").build()}).build();
    private static final SdkField<List<String>> ENABLED_LOGGING_STRATEGIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledLoggingStrategies").getter(LogConfiguration.getter(LogConfiguration::enabledLoggingStrategiesAsStrings)).setter(LogConfiguration.setter(Builder::enabledLoggingStrategiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledLoggingStrategies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENT_ENABLED_FIELD, ENABLED_LOGGING_STRATEGIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LogConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer percentEnabled;
    private final List<String> enabledLoggingStrategies;

    private LogConfiguration(BuilderImpl builder) {
        this.percentEnabled = builder.percentEnabled;
        this.enabledLoggingStrategies = builder.enabledLoggingStrategies;
    }

    public final Integer percentEnabled() {
        return this.percentEnabled;
    }

    public final List<LoggingStrategy> enabledLoggingStrategies() {
        return ___listOfLoggingStrategiesCopier.copyStringToEnum(this.enabledLoggingStrategies);
    }

    public final boolean hasEnabledLoggingStrategies() {
        return this.enabledLoggingStrategies != null && !(this.enabledLoggingStrategies instanceof SdkAutoConstructList);
    }

    public final List<String> enabledLoggingStrategiesAsStrings() {
        return this.enabledLoggingStrategies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.percentEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledLoggingStrategies() ? this.enabledLoggingStrategiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration)obj;
        return Objects.equals(this.percentEnabled(), other.percentEnabled()) && this.hasEnabledLoggingStrategies() == other.hasEnabledLoggingStrategies() && Objects.equals(this.enabledLoggingStrategiesAsStrings(), other.enabledLoggingStrategiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"LogConfiguration").add("PercentEnabled", (Object)this.percentEnabled()).add("EnabledLoggingStrategies", this.hasEnabledLoggingStrategies() ? this.enabledLoggingStrategiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PercentEnabled": {
                return Optional.ofNullable(clazz.cast(this.percentEnabled()));
            }
            case "EnabledLoggingStrategies": {
                return Optional.ofNullable(clazz.cast(this.enabledLoggingStrategiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PercentEnabled", PERCENT_ENABLED_FIELD);
        map.put("EnabledLoggingStrategies", ENABLED_LOGGING_STRATEGIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogConfiguration, T> g) {
        return obj -> g.apply((LogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer percentEnabled;
        private List<String> enabledLoggingStrategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfiguration model) {
            this.percentEnabled(model.percentEnabled);
            this.enabledLoggingStrategiesWithStrings(model.enabledLoggingStrategies);
        }

        public final Integer getPercentEnabled() {
            return this.percentEnabled;
        }

        public final void setPercentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
        }

        @Override
        public final Builder percentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
            return this;
        }

        public final Collection<String> getEnabledLoggingStrategies() {
            if (this.enabledLoggingStrategies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledLoggingStrategies;
        }

        public final void setEnabledLoggingStrategies(Collection<String> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copy(enabledLoggingStrategies);
        }

        @Override
        public final Builder enabledLoggingStrategiesWithStrings(Collection<String> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copy(enabledLoggingStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledLoggingStrategiesWithStrings(String ... enabledLoggingStrategies) {
            this.enabledLoggingStrategiesWithStrings(Arrays.asList(enabledLoggingStrategies));
            return this;
        }

        @Override
        public final Builder enabledLoggingStrategies(Collection<LoggingStrategy> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copyEnumToString(enabledLoggingStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledLoggingStrategies(LoggingStrategy ... enabledLoggingStrategies) {
            this.enabledLoggingStrategies(Arrays.asList(enabledLoggingStrategies));
            return this;
        }

        public LogConfiguration build() {
            return new LogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogConfiguration> {
        public Builder percentEnabled(Integer var1);

        public Builder enabledLoggingStrategiesWithStrings(Collection<String> var1);

        public Builder enabledLoggingStrategiesWithStrings(String ... var1);

        public Builder enabledLoggingStrategies(Collection<LoggingStrategy> var1);

        public Builder enabledLoggingStrategies(LoggingStrategy ... var1);
    }
}

