/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LoggingStrategy {
    VENDED_LOGS("VENDED_LOGS"),
    LEGACY_CLOUDWATCH("LEGACY_CLOUDWATCH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LoggingStrategy> VALUE_MAP;
    private final String value;

    private LoggingStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LoggingStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LoggingStrategy> knownValues() {
        EnumSet<LoggingStrategy> knownValues = EnumSet.allOf(LoggingStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LoggingStrategy.class, LoggingStrategy::toString);
    }
}

