/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediatailor.model.HttpPackageConfiguration;
import software.amazon.awssdk.services.mediatailor.model.HttpPackageConfigurationsCopier;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorResponse;
import software.amazon.awssdk.services.mediatailor.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLiveSourceResponse
extends MediaTailorResponse
implements ToCopyableBuilder<Builder, UpdateLiveSourceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateLiveSourceResponse.getter(UpdateLiveSourceResponse::arn)).setter(UpdateLiveSourceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(UpdateLiveSourceResponse.getter(UpdateLiveSourceResponse::creationTime)).setter(UpdateLiveSourceResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<List<HttpPackageConfiguration>> HTTP_PACKAGE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HttpPackageConfigurations").getter(UpdateLiveSourceResponse.getter(UpdateLiveSourceResponse::httpPackageConfigurations)).setter(UpdateLiveSourceResponse.setter(Builder::httpPackageConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPackageConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpPackageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(UpdateLiveSourceResponse.getter(UpdateLiveSourceResponse::lastModifiedTime)).setter(UpdateLiveSourceResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> LIVE_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LiveSourceName").getter(UpdateLiveSourceResponse.getter(UpdateLiveSourceResponse::liveSourceName)).setter(UpdateLiveSourceResponse.setter(Builder::liveSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LiveSourceName").build()}).build();
    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLocationName").getter(UpdateLiveSourceResponse.getter(UpdateLiveSourceResponse::sourceLocationName)).setter(UpdateLiveSourceResponse.setter(Builder::sourceLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdateLiveSourceResponse.getter(UpdateLiveSourceResponse::tags)).setter(UpdateLiveSourceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, HTTP_PACKAGE_CONFIGURATIONS_FIELD, LAST_MODIFIED_TIME_FIELD, LIVE_SOURCE_NAME_FIELD, SOURCE_LOCATION_NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLiveSourceResponse.memberNameToFieldInitializer();
    private final String arn;
    private final Instant creationTime;
    private final List<HttpPackageConfiguration> httpPackageConfigurations;
    private final Instant lastModifiedTime;
    private final String liveSourceName;
    private final String sourceLocationName;
    private final Map<String, String> tags;

    private UpdateLiveSourceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.httpPackageConfigurations = builder.httpPackageConfigurations;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.liveSourceName = builder.liveSourceName;
        this.sourceLocationName = builder.sourceLocationName;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasHttpPackageConfigurations() {
        return this.httpPackageConfigurations != null && !(this.httpPackageConfigurations instanceof SdkAutoConstructList);
    }

    public final List<HttpPackageConfiguration> httpPackageConfigurations() {
        return this.httpPackageConfigurations;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String liveSourceName() {
        return this.liveSourceName;
    }

    public final String sourceLocationName() {
        return this.sourceLocationName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHttpPackageConfigurations() ? this.httpPackageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.liveSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLiveSourceResponse)) {
            return false;
        }
        UpdateLiveSourceResponse other = (UpdateLiveSourceResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasHttpPackageConfigurations() == other.hasHttpPackageConfigurations() && Objects.equals(this.httpPackageConfigurations(), other.httpPackageConfigurations()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.liveSourceName(), other.liveSourceName()) && Objects.equals(this.sourceLocationName(), other.sourceLocationName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLiveSourceResponse").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("HttpPackageConfigurations", this.hasHttpPackageConfigurations() ? this.httpPackageConfigurations() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LiveSourceName", (Object)this.liveSourceName()).add("SourceLocationName", (Object)this.sourceLocationName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "HttpPackageConfigurations": {
                return Optional.ofNullable(clazz.cast(this.httpPackageConfigurations()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LiveSourceName": {
                return Optional.ofNullable(clazz.cast(this.liveSourceName()));
            }
            case "SourceLocationName": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("HttpPackageConfigurations", HTTP_PACKAGE_CONFIGURATIONS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LiveSourceName", LIVE_SOURCE_NAME_FIELD);
        map.put("SourceLocationName", SOURCE_LOCATION_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLiveSourceResponse, T> g) {
        return obj -> g.apply((UpdateLiveSourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private List<HttpPackageConfiguration> httpPackageConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedTime;
        private String liveSourceName;
        private String sourceLocationName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLiveSourceResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.httpPackageConfigurations(model.httpPackageConfigurations);
            this.lastModifiedTime(model.lastModifiedTime);
            this.liveSourceName(model.liveSourceName);
            this.sourceLocationName(model.sourceLocationName);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<HttpPackageConfiguration.Builder> getHttpPackageConfigurations() {
            List<HttpPackageConfiguration.Builder> result = HttpPackageConfigurationsCopier.copyToBuilder(this.httpPackageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHttpPackageConfigurations(Collection<HttpPackageConfiguration.BuilderImpl> httpPackageConfigurations) {
            this.httpPackageConfigurations = HttpPackageConfigurationsCopier.copyFromBuilder(httpPackageConfigurations);
        }

        @Override
        public final Builder httpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations) {
            this.httpPackageConfigurations = HttpPackageConfigurationsCopier.copy(httpPackageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpPackageConfigurations(HttpPackageConfiguration ... httpPackageConfigurations) {
            this.httpPackageConfigurations(Arrays.asList(httpPackageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpPackageConfigurations(Consumer<HttpPackageConfiguration.Builder> ... httpPackageConfigurations) {
            this.httpPackageConfigurations(Stream.of(httpPackageConfigurations).map(c -> (HttpPackageConfiguration)((HttpPackageConfiguration.Builder)HttpPackageConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLiveSourceName() {
            return this.liveSourceName;
        }

        public final void setLiveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
        }

        @Override
        public final Builder liveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
            return this;
        }

        public final String getSourceLocationName() {
            return this.sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateLiveSourceResponse build() {
            return new UpdateLiveSourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaTailorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLiveSourceResponse> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder httpPackageConfigurations(Collection<HttpPackageConfiguration> var1);

        public Builder httpPackageConfigurations(HttpPackageConfiguration ... var1);

        public Builder httpPackageConfigurations(Consumer<HttpPackageConfiguration.Builder> ... var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder liveSourceName(String var1);

        public Builder sourceLocationName(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

