/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.LoggingStrategy;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorRequest;
import software.amazon.awssdk.services.mediatailor.model.___listOfLoggingStrategiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigureLogsForPlaybackConfigurationRequest
extends MediaTailorRequest
implements ToCopyableBuilder<Builder, ConfigureLogsForPlaybackConfigurationRequest> {
    private static final SdkField<Integer> PERCENT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PercentEnabled").getter(ConfigureLogsForPlaybackConfigurationRequest.getter(ConfigureLogsForPlaybackConfigurationRequest::percentEnabled)).setter(ConfigureLogsForPlaybackConfigurationRequest.setter(Builder::percentEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentEnabled").build()}).build();
    private static final SdkField<String> PLAYBACK_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaybackConfigurationName").getter(ConfigureLogsForPlaybackConfigurationRequest.getter(ConfigureLogsForPlaybackConfigurationRequest::playbackConfigurationName)).setter(ConfigureLogsForPlaybackConfigurationRequest.setter(Builder::playbackConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackConfigurationName").build()}).build();
    private static final SdkField<List<String>> ENABLED_LOGGING_STRATEGIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledLoggingStrategies").getter(ConfigureLogsForPlaybackConfigurationRequest.getter(ConfigureLogsForPlaybackConfigurationRequest::enabledLoggingStrategiesAsStrings)).setter(ConfigureLogsForPlaybackConfigurationRequest.setter(Builder::enabledLoggingStrategiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledLoggingStrategies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENT_ENABLED_FIELD, PLAYBACK_CONFIGURATION_NAME_FIELD, ENABLED_LOGGING_STRATEGIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigureLogsForPlaybackConfigurationRequest.memberNameToFieldInitializer();
    private final Integer percentEnabled;
    private final String playbackConfigurationName;
    private final List<String> enabledLoggingStrategies;

    private ConfigureLogsForPlaybackConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.percentEnabled = builder.percentEnabled;
        this.playbackConfigurationName = builder.playbackConfigurationName;
        this.enabledLoggingStrategies = builder.enabledLoggingStrategies;
    }

    public final Integer percentEnabled() {
        return this.percentEnabled;
    }

    public final String playbackConfigurationName() {
        return this.playbackConfigurationName;
    }

    public final List<LoggingStrategy> enabledLoggingStrategies() {
        return ___listOfLoggingStrategiesCopier.copyStringToEnum(this.enabledLoggingStrategies);
    }

    public final boolean hasEnabledLoggingStrategies() {
        return this.enabledLoggingStrategies != null && !(this.enabledLoggingStrategies instanceof SdkAutoConstructList);
    }

    public final List<String> enabledLoggingStrategiesAsStrings() {
        return this.enabledLoggingStrategies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.percentEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledLoggingStrategies() ? this.enabledLoggingStrategiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureLogsForPlaybackConfigurationRequest)) {
            return false;
        }
        ConfigureLogsForPlaybackConfigurationRequest other = (ConfigureLogsForPlaybackConfigurationRequest)((Object)obj);
        return Objects.equals(this.percentEnabled(), other.percentEnabled()) && Objects.equals(this.playbackConfigurationName(), other.playbackConfigurationName()) && this.hasEnabledLoggingStrategies() == other.hasEnabledLoggingStrategies() && Objects.equals(this.enabledLoggingStrategiesAsStrings(), other.enabledLoggingStrategiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigureLogsForPlaybackConfigurationRequest").add("PercentEnabled", (Object)this.percentEnabled()).add("PlaybackConfigurationName", (Object)this.playbackConfigurationName()).add("EnabledLoggingStrategies", this.hasEnabledLoggingStrategies() ? this.enabledLoggingStrategiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PercentEnabled": {
                return Optional.ofNullable(clazz.cast(this.percentEnabled()));
            }
            case "PlaybackConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.playbackConfigurationName()));
            }
            case "EnabledLoggingStrategies": {
                return Optional.ofNullable(clazz.cast(this.enabledLoggingStrategiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PercentEnabled", PERCENT_ENABLED_FIELD);
        map.put("PlaybackConfigurationName", PLAYBACK_CONFIGURATION_NAME_FIELD);
        map.put("EnabledLoggingStrategies", ENABLED_LOGGING_STRATEGIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigureLogsForPlaybackConfigurationRequest, T> g) {
        return obj -> g.apply((ConfigureLogsForPlaybackConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorRequest.BuilderImpl
    implements Builder {
        private Integer percentEnabled;
        private String playbackConfigurationName;
        private List<String> enabledLoggingStrategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureLogsForPlaybackConfigurationRequest model) {
            super(model);
            this.percentEnabled(model.percentEnabled);
            this.playbackConfigurationName(model.playbackConfigurationName);
            this.enabledLoggingStrategiesWithStrings(model.enabledLoggingStrategies);
        }

        public final Integer getPercentEnabled() {
            return this.percentEnabled;
        }

        public final void setPercentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
        }

        @Override
        public final Builder percentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
            return this;
        }

        public final String getPlaybackConfigurationName() {
            return this.playbackConfigurationName;
        }

        public final void setPlaybackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
        }

        @Override
        public final Builder playbackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
            return this;
        }

        public final Collection<String> getEnabledLoggingStrategies() {
            if (this.enabledLoggingStrategies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledLoggingStrategies;
        }

        public final void setEnabledLoggingStrategies(Collection<String> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copy(enabledLoggingStrategies);
        }

        @Override
        public final Builder enabledLoggingStrategiesWithStrings(Collection<String> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copy(enabledLoggingStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledLoggingStrategiesWithStrings(String ... enabledLoggingStrategies) {
            this.enabledLoggingStrategiesWithStrings(Arrays.asList(enabledLoggingStrategies));
            return this;
        }

        @Override
        public final Builder enabledLoggingStrategies(Collection<LoggingStrategy> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copyEnumToString(enabledLoggingStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledLoggingStrategies(LoggingStrategy ... enabledLoggingStrategies) {
            this.enabledLoggingStrategies(Arrays.asList(enabledLoggingStrategies));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfigureLogsForPlaybackConfigurationRequest build() {
            return new ConfigureLogsForPlaybackConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaTailorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConfigureLogsForPlaybackConfigurationRequest> {
        public Builder percentEnabled(Integer var1);

        public Builder playbackConfigurationName(String var1);

        public Builder enabledLoggingStrategiesWithStrings(Collection<String> var1);

        public Builder enabledLoggingStrategiesWithStrings(String ... var1);

        public Builder enabledLoggingStrategies(Collection<LoggingStrategy> var1);

        public Builder enabledLoggingStrategies(LoggingStrategy ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

