/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorClient;
import software.amazon.awssdk.services.mediatailor.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest;
import software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse;
import software.amazon.awssdk.services.mediatailor.model.VodSource;

public class ListVodSourcesIterable
implements SdkIterable<ListVodSourcesResponse> {
    private final MediaTailorClient client;
    private final ListVodSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVodSourcesIterable(MediaTailorClient client, ListVodSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVodSourcesResponseFetcher();
    }

    public Iterator<ListVodSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VodSource> items() {
        Function<ListVodSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVodSourcesResponseFetcher
    implements SyncPageFetcher<ListVodSourcesResponse> {
        private ListVodSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListVodSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVodSourcesResponse nextPage(ListVodSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListVodSourcesIterable.this.client.listVodSources(ListVodSourcesIterable.this.firstRequest);
            }
            return ListVodSourcesIterable.this.client.listVodSources((ListVodSourcesRequest)((Object)ListVodSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

