/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.LogType;
import software.amazon.awssdk.services.mediatailor.model.LogTypesCopier;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigureLogsForChannelRequest
extends MediaTailorRequest
implements ToCopyableBuilder<Builder, ConfigureLogsForChannelRequest> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(ConfigureLogsForChannelRequest.getter(ConfigureLogsForChannelRequest::channelName)).setter(ConfigureLogsForChannelRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<List<String>> LOG_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogTypes").getter(ConfigureLogsForChannelRequest.getter(ConfigureLogsForChannelRequest::logTypesAsStrings)).setter(ConfigureLogsForChannelRequest.setter(Builder::logTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD, LOG_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ChannelName", CHANNEL_NAME_FIELD);
            this.put("LogTypes", LOG_TYPES_FIELD);
        }
    });
    private final String channelName;
    private final List<String> logTypes;

    private ConfigureLogsForChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.logTypes = builder.logTypes;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final List<LogType> logTypes() {
        return LogTypesCopier.copyStringToEnum(this.logTypes);
    }

    public final boolean hasLogTypes() {
        return this.logTypes != null && !(this.logTypes instanceof SdkAutoConstructList);
    }

    public final List<String> logTypesAsStrings() {
        return this.logTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogTypes() ? this.logTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureLogsForChannelRequest)) {
            return false;
        }
        ConfigureLogsForChannelRequest other = (ConfigureLogsForChannelRequest)((Object)obj);
        return Objects.equals(this.channelName(), other.channelName()) && this.hasLogTypes() == other.hasLogTypes() && Objects.equals(this.logTypesAsStrings(), other.logTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigureLogsForChannelRequest").add("ChannelName", (Object)this.channelName()).add("LogTypes", this.hasLogTypes() ? this.logTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "LogTypes": {
                return Optional.ofNullable(clazz.cast(this.logTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureLogsForChannelRequest, T> g) {
        return obj -> g.apply((ConfigureLogsForChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorRequest.BuilderImpl
    implements Builder {
        private String channelName;
        private List<String> logTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureLogsForChannelRequest model) {
            super(model);
            this.channelName(model.channelName);
            this.logTypesWithStrings(model.logTypes);
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final Collection<String> getLogTypes() {
            if (this.logTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logTypes;
        }

        public final void setLogTypes(Collection<String> logTypes) {
            this.logTypes = LogTypesCopier.copy(logTypes);
        }

        @Override
        public final Builder logTypesWithStrings(Collection<String> logTypes) {
            this.logTypes = LogTypesCopier.copy(logTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypesWithStrings(String ... logTypes) {
            this.logTypesWithStrings(Arrays.asList(logTypes));
            return this;
        }

        @Override
        public final Builder logTypes(Collection<LogType> logTypes) {
            this.logTypes = LogTypesCopier.copyEnumToString(logTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypes(LogType ... logTypes) {
            this.logTypes(Arrays.asList(logTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfigureLogsForChannelRequest build() {
            return new ConfigureLogsForChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaTailorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConfigureLogsForChannelRequest> {
        public Builder channelName(String var1);

        public Builder logTypesWithStrings(Collection<String> var1);

        public Builder logTypesWithStrings(String ... var1);

        public Builder logTypes(Collection<LogType> var1);

        public Builder logTypes(LogType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

