/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AlertCategory {
    SCHEDULING_ERROR("SCHEDULING_ERROR"),
    PLAYBACK_WARNING("PLAYBACK_WARNING"),
    INFO("INFO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AlertCategory> VALUE_MAP;
    private final String value;

    private AlertCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AlertCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AlertCategory> knownValues() {
        EnumSet<AlertCategory> knownValues = EnumSet.allOf(AlertCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AlertCategory.class, AlertCategory::toString);
    }
}

