/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AdMarkupType {
    DATERANGE("DATERANGE"),
    SCTE35_ENHANCED("SCTE35_ENHANCED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AdMarkupType> VALUE_MAP;
    private final String value;

    private AdMarkupType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AdMarkupType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AdMarkupType> knownValues() {
        EnumSet<AdMarkupType> knownValues = EnumSet.allOf(AdMarkupType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AdMarkupType.class, AdMarkupType::toString);
    }
}

