/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.AdBreakMetadataListCopier;
import software.amazon.awssdk.services.mediatailor.model.KeyValuePair;
import software.amazon.awssdk.services.mediatailor.model.MessageType;
import software.amazon.awssdk.services.mediatailor.model.SlateSource;
import software.amazon.awssdk.services.mediatailor.model.SpliceInsertMessage;
import software.amazon.awssdk.services.mediatailor.model.TimeSignalMessage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdBreak
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdBreak> {
    private static final SdkField<List<KeyValuePair>> AD_BREAK_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdBreakMetadata").getter(AdBreak.getter(AdBreak::adBreakMetadata)).setter(AdBreak.setter(Builder::adBreakMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdBreakMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageType").getter(AdBreak.getter(AdBreak::messageTypeAsString)).setter(AdBreak.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()}).build();
    private static final SdkField<Long> OFFSET_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("OffsetMillis").getter(AdBreak.getter(AdBreak::offsetMillis)).setter(AdBreak.setter(Builder::offsetMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffsetMillis").build()}).build();
    private static final SdkField<SlateSource> SLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Slate").getter(AdBreak.getter(AdBreak::slate)).setter(AdBreak.setter(Builder::slate)).constructor(SlateSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slate").build()}).build();
    private static final SdkField<SpliceInsertMessage> SPLICE_INSERT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpliceInsertMessage").getter(AdBreak.getter(AdBreak::spliceInsertMessage)).setter(AdBreak.setter(Builder::spliceInsertMessage)).constructor(SpliceInsertMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpliceInsertMessage").build()}).build();
    private static final SdkField<TimeSignalMessage> TIME_SIGNAL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeSignalMessage").getter(AdBreak.getter(AdBreak::timeSignalMessage)).setter(AdBreak.setter(Builder::timeSignalMessage)).constructor(TimeSignalMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSignalMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_BREAK_METADATA_FIELD, MESSAGE_TYPE_FIELD, OFFSET_MILLIS_FIELD, SLATE_FIELD, SPLICE_INSERT_MESSAGE_FIELD, TIME_SIGNAL_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<KeyValuePair> adBreakMetadata;
    private final String messageType;
    private final Long offsetMillis;
    private final SlateSource slate;
    private final SpliceInsertMessage spliceInsertMessage;
    private final TimeSignalMessage timeSignalMessage;

    private AdBreak(BuilderImpl builder) {
        this.adBreakMetadata = builder.adBreakMetadata;
        this.messageType = builder.messageType;
        this.offsetMillis = builder.offsetMillis;
        this.slate = builder.slate;
        this.spliceInsertMessage = builder.spliceInsertMessage;
        this.timeSignalMessage = builder.timeSignalMessage;
    }

    public final boolean hasAdBreakMetadata() {
        return this.adBreakMetadata != null && !(this.adBreakMetadata instanceof SdkAutoConstructList);
    }

    public final List<KeyValuePair> adBreakMetadata() {
        return this.adBreakMetadata;
    }

    public final MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public final String messageTypeAsString() {
        return this.messageType;
    }

    public final Long offsetMillis() {
        return this.offsetMillis;
    }

    public final SlateSource slate() {
        return this.slate;
    }

    public final SpliceInsertMessage spliceInsertMessage() {
        return this.spliceInsertMessage;
    }

    public final TimeSignalMessage timeSignalMessage() {
        return this.timeSignalMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdBreakMetadata() ? this.adBreakMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.slate());
        hashCode = 31 * hashCode + Objects.hashCode(this.spliceInsertMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSignalMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdBreak)) {
            return false;
        }
        AdBreak other = (AdBreak)obj;
        return this.hasAdBreakMetadata() == other.hasAdBreakMetadata() && Objects.equals(this.adBreakMetadata(), other.adBreakMetadata()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString()) && Objects.equals(this.offsetMillis(), other.offsetMillis()) && Objects.equals(this.slate(), other.slate()) && Objects.equals(this.spliceInsertMessage(), other.spliceInsertMessage()) && Objects.equals(this.timeSignalMessage(), other.timeSignalMessage());
    }

    public final String toString() {
        return ToString.builder((String)"AdBreak").add("AdBreakMetadata", this.hasAdBreakMetadata() ? this.adBreakMetadata() : null).add("MessageType", (Object)this.messageTypeAsString()).add("OffsetMillis", (Object)this.offsetMillis()).add("Slate", (Object)this.slate()).add("SpliceInsertMessage", (Object)this.spliceInsertMessage()).add("TimeSignalMessage", (Object)this.timeSignalMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdBreakMetadata": {
                return Optional.ofNullable(clazz.cast(this.adBreakMetadata()));
            }
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
            case "OffsetMillis": {
                return Optional.ofNullable(clazz.cast(this.offsetMillis()));
            }
            case "Slate": {
                return Optional.ofNullable(clazz.cast(this.slate()));
            }
            case "SpliceInsertMessage": {
                return Optional.ofNullable(clazz.cast(this.spliceInsertMessage()));
            }
            case "TimeSignalMessage": {
                return Optional.ofNullable(clazz.cast(this.timeSignalMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdBreak, T> g) {
        return obj -> g.apply((AdBreak)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<KeyValuePair> adBreakMetadata = DefaultSdkAutoConstructList.getInstance();
        private String messageType;
        private Long offsetMillis;
        private SlateSource slate;
        private SpliceInsertMessage spliceInsertMessage;
        private TimeSignalMessage timeSignalMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AdBreak model) {
            this.adBreakMetadata(model.adBreakMetadata);
            this.messageType(model.messageType);
            this.offsetMillis(model.offsetMillis);
            this.slate(model.slate);
            this.spliceInsertMessage(model.spliceInsertMessage);
            this.timeSignalMessage(model.timeSignalMessage);
        }

        public final List<KeyValuePair.Builder> getAdBreakMetadata() {
            List<KeyValuePair.Builder> result = AdBreakMetadataListCopier.copyToBuilder(this.adBreakMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdBreakMetadata(Collection<KeyValuePair.BuilderImpl> adBreakMetadata) {
            this.adBreakMetadata = AdBreakMetadataListCopier.copyFromBuilder(adBreakMetadata);
        }

        @Override
        public final Builder adBreakMetadata(Collection<KeyValuePair> adBreakMetadata) {
            this.adBreakMetadata = AdBreakMetadataListCopier.copy(adBreakMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreakMetadata(KeyValuePair ... adBreakMetadata) {
            this.adBreakMetadata(Arrays.asList(adBreakMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreakMetadata(Consumer<KeyValuePair.Builder> ... adBreakMetadata) {
            this.adBreakMetadata(Stream.of(adBreakMetadata).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final Long getOffsetMillis() {
            return this.offsetMillis;
        }

        public final void setOffsetMillis(Long offsetMillis) {
            this.offsetMillis = offsetMillis;
        }

        @Override
        public final Builder offsetMillis(Long offsetMillis) {
            this.offsetMillis = offsetMillis;
            return this;
        }

        public final SlateSource.Builder getSlate() {
            return this.slate != null ? this.slate.toBuilder() : null;
        }

        public final void setSlate(SlateSource.BuilderImpl slate) {
            this.slate = slate != null ? slate.build() : null;
        }

        @Override
        public final Builder slate(SlateSource slate) {
            this.slate = slate;
            return this;
        }

        public final SpliceInsertMessage.Builder getSpliceInsertMessage() {
            return this.spliceInsertMessage != null ? this.spliceInsertMessage.toBuilder() : null;
        }

        public final void setSpliceInsertMessage(SpliceInsertMessage.BuilderImpl spliceInsertMessage) {
            this.spliceInsertMessage = spliceInsertMessage != null ? spliceInsertMessage.build() : null;
        }

        @Override
        public final Builder spliceInsertMessage(SpliceInsertMessage spliceInsertMessage) {
            this.spliceInsertMessage = spliceInsertMessage;
            return this;
        }

        public final TimeSignalMessage.Builder getTimeSignalMessage() {
            return this.timeSignalMessage != null ? this.timeSignalMessage.toBuilder() : null;
        }

        public final void setTimeSignalMessage(TimeSignalMessage.BuilderImpl timeSignalMessage) {
            this.timeSignalMessage = timeSignalMessage != null ? timeSignalMessage.build() : null;
        }

        @Override
        public final Builder timeSignalMessage(TimeSignalMessage timeSignalMessage) {
            this.timeSignalMessage = timeSignalMessage;
            return this;
        }

        public AdBreak build() {
            return new AdBreak(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdBreak> {
        public Builder adBreakMetadata(Collection<KeyValuePair> var1);

        public Builder adBreakMetadata(KeyValuePair ... var1);

        public Builder adBreakMetadata(Consumer<KeyValuePair.Builder> ... var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder offsetMillis(Long var1);

        public Builder slate(SlateSource var1);

        default public Builder slate(Consumer<SlateSource.Builder> slate) {
            return this.slate((SlateSource)((SlateSource.Builder)SlateSource.builder().applyMutation(slate)).build());
        }

        public Builder spliceInsertMessage(SpliceInsertMessage var1);

        default public Builder spliceInsertMessage(Consumer<SpliceInsertMessage.Builder> spliceInsertMessage) {
            return this.spliceInsertMessage((SpliceInsertMessage)((SpliceInsertMessage.Builder)SpliceInsertMessage.builder().applyMutation(spliceInsertMessage)).build());
        }

        public Builder timeSignalMessage(TimeSignalMessage var1);

        default public Builder timeSignalMessage(Consumer<TimeSignalMessage.Builder> timeSignalMessage) {
            return this.timeSignalMessage((TimeSignalMessage)((TimeSignalMessage.Builder)TimeSignalMessage.builder().applyMutation(timeSignalMessage)).build());
        }
    }
}

