/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediatailor.DefaultMediaTailorBaseClientBuilder;
import software.amazon.awssdk.services.mediatailor.DefaultMediaTailorClient;
import software.amazon.awssdk.services.mediatailor.MediaTailorClient;
import software.amazon.awssdk.services.mediatailor.MediaTailorClientBuilder;
import software.amazon.awssdk.services.mediatailor.MediaTailorServiceClientConfiguration;
import software.amazon.awssdk.services.mediatailor.endpoints.MediaTailorEndpointProvider;

@SdkInternalApi
final class DefaultMediaTailorClientBuilder
extends DefaultMediaTailorBaseClientBuilder<MediaTailorClientBuilder, MediaTailorClient>
implements MediaTailorClientBuilder {
    DefaultMediaTailorClientBuilder() {
    }

    @Override
    public DefaultMediaTailorClientBuilder endpointProvider(MediaTailorEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaTailorClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMediaTailorClientBuilder.validateClientOptions(clientConfiguration);
        MediaTailorServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMediaTailorClient client = new DefaultMediaTailorClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MediaTailorServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MediaTailorServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

