/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorAsyncClient;
import software.amazon.awssdk.services.mediatailor.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest;
import software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse;
import software.amazon.awssdk.services.mediatailor.model.PrefetchSchedule;

public class ListPrefetchSchedulesPublisher
implements SdkPublisher<ListPrefetchSchedulesResponse> {
    private final MediaTailorAsyncClient client;
    private final ListPrefetchSchedulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPrefetchSchedulesPublisher(MediaTailorAsyncClient client, ListPrefetchSchedulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPrefetchSchedulesPublisher(MediaTailorAsyncClient client, ListPrefetchSchedulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPrefetchSchedulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPrefetchSchedulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PrefetchSchedule> items() {
        Function<ListPrefetchSchedulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPrefetchSchedulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPrefetchSchedulesResponseFetcher
    implements AsyncPageFetcher<ListPrefetchSchedulesResponse> {
        private ListPrefetchSchedulesResponseFetcher() {
        }

        public boolean hasNextPage(ListPrefetchSchedulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPrefetchSchedulesResponse> nextPage(ListPrefetchSchedulesResponse previousPage) {
            if (previousPage == null) {
                return ListPrefetchSchedulesPublisher.this.client.listPrefetchSchedules(ListPrefetchSchedulesPublisher.this.firstRequest);
            }
            return ListPrefetchSchedulesPublisher.this.client.listPrefetchSchedules((ListPrefetchSchedulesRequest)((Object)ListPrefetchSchedulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

