/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediatailor.DefaultMediaTailorAsyncClient;
import software.amazon.awssdk.services.mediatailor.DefaultMediaTailorBaseClientBuilder;
import software.amazon.awssdk.services.mediatailor.MediaTailorAsyncClient;
import software.amazon.awssdk.services.mediatailor.MediaTailorAsyncClientBuilder;
import software.amazon.awssdk.services.mediatailor.MediaTailorServiceClientConfiguration;
import software.amazon.awssdk.services.mediatailor.endpoints.MediaTailorEndpointProvider;

@SdkInternalApi
final class DefaultMediaTailorAsyncClientBuilder
extends DefaultMediaTailorBaseClientBuilder<MediaTailorAsyncClientBuilder, MediaTailorAsyncClient>
implements MediaTailorAsyncClientBuilder {
    DefaultMediaTailorAsyncClientBuilder() {
    }

    @Override
    public DefaultMediaTailorAsyncClientBuilder endpointProvider(MediaTailorEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaTailorAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMediaTailorAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MediaTailorServiceClientConfiguration serviceClientConfiguration = MediaTailorServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMediaTailorAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

