/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorClient;
import software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesRequest;
import software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesResponse;
import software.amazon.awssdk.services.mediatailor.model.LiveSource;

public class ListLiveSourcesIterable
implements SdkIterable<ListLiveSourcesResponse> {
    private final MediaTailorClient client;
    private final ListLiveSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLiveSourcesIterable(MediaTailorClient client, ListLiveSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLiveSourcesResponseFetcher();
    }

    public Iterator<ListLiveSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LiveSource> items() {
        Function<ListLiveSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLiveSourcesResponseFetcher
    implements SyncPageFetcher<ListLiveSourcesResponse> {
        private ListLiveSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListLiveSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLiveSourcesResponse nextPage(ListLiveSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListLiveSourcesIterable.this.client.listLiveSources(ListLiveSourcesIterable.this.firstRequest);
            }
            return ListLiveSourcesIterable.this.client.listLiveSources((ListLiveSourcesRequest)((Object)ListLiveSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

