/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProgramRequest extends MediaTailorRequest implements
        ToCopyableBuilder<UpdateProgramRequest.Builder, UpdateProgramRequest> {
    private static final SdkField<List<AdBreak>> AD_BREAKS_FIELD = SdkField
            .<List<AdBreak>> builder(MarshallingType.LIST)
            .memberName("AdBreaks")
            .getter(getter(UpdateProgramRequest::adBreaks))
            .setter(setter(Builder::adBreaks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdBreaks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdBreak> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdBreak::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(UpdateProgramRequest::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()).build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgramName").getter(getter(UpdateProgramRequest::programName)).setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ProgramName").build()).build();

    private static final SdkField<UpdateProgramScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField
            .<UpdateProgramScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScheduleConfiguration")
            .getter(getter(UpdateProgramRequest::scheduleConfiguration)).setter(setter(Builder::scheduleConfiguration))
            .constructor(UpdateProgramScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_BREAKS_FIELD,
            CHANNEL_NAME_FIELD, PROGRAM_NAME_FIELD, SCHEDULE_CONFIGURATION_FIELD));

    private final List<AdBreak> adBreaks;

    private final String channelName;

    private final String programName;

    private final UpdateProgramScheduleConfiguration scheduleConfiguration;

    private UpdateProgramRequest(BuilderImpl builder) {
        super(builder);
        this.adBreaks = builder.adBreaks;
        this.channelName = builder.channelName;
        this.programName = builder.programName;
        this.scheduleConfiguration = builder.scheduleConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdBreaks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAdBreaks() {
        return adBreaks != null && !(adBreaks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ad break configuration settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdBreaks} method.
     * </p>
     * 
     * @return The ad break configuration settings.
     */
    public final List<AdBreak> adBreaks() {
        return adBreaks;
    }

    /**
     * <p>
     * The name of the channel for this Program.
     * </p>
     * 
     * @return The name of the channel for this Program.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name of the Program.
     * </p>
     * 
     * @return The name of the Program.
     */
    public final String programName() {
        return programName;
    }

    /**
     * <p>
     * The schedule configuration settings.
     * </p>
     * 
     * @return The schedule configuration settings.
     */
    public final UpdateProgramScheduleConfiguration scheduleConfiguration() {
        return scheduleConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdBreaks() ? adBreaks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProgramRequest)) {
            return false;
        }
        UpdateProgramRequest other = (UpdateProgramRequest) obj;
        return hasAdBreaks() == other.hasAdBreaks() && Objects.equals(adBreaks(), other.adBreaks())
                && Objects.equals(channelName(), other.channelName()) && Objects.equals(programName(), other.programName())
                && Objects.equals(scheduleConfiguration(), other.scheduleConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProgramRequest").add("AdBreaks", hasAdBreaks() ? adBreaks() : null)
                .add("ChannelName", channelName()).add("ProgramName", programName())
                .add("ScheduleConfiguration", scheduleConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdBreaks":
            return Optional.ofNullable(clazz.cast(adBreaks()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        case "ScheduleConfiguration":
            return Optional.ofNullable(clazz.cast(scheduleConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProgramRequest, T> g) {
        return obj -> g.apply((UpdateProgramRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProgramRequest> {
        /**
         * <p>
         * The ad break configuration settings.
         * </p>
         * 
         * @param adBreaks
         *        The ad break configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adBreaks(Collection<AdBreak> adBreaks);

        /**
         * <p>
         * The ad break configuration settings.
         * </p>
         * 
         * @param adBreaks
         *        The ad break configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adBreaks(AdBreak... adBreaks);

        /**
         * <p>
         * The ad break configuration settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.AdBreak.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mediatailor.model.AdBreak#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.AdBreak.Builder#build()} is called immediately and
         * its result is passed to {@link #adBreaks(List<AdBreak>)}.
         * 
         * @param adBreaks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.AdBreak.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adBreaks(java.util.Collection<AdBreak>)
         */
        Builder adBreaks(Consumer<AdBreak.Builder>... adBreaks);

        /**
         * <p>
         * The name of the channel for this Program.
         * </p>
         * 
         * @param channelName
         *        The name of the channel for this Program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name of the Program.
         * </p>
         * 
         * @param programName
         *        The name of the Program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);

        /**
         * <p>
         * The schedule configuration settings.
         * </p>
         * 
         * @param scheduleConfiguration
         *        The schedule configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfiguration(UpdateProgramScheduleConfiguration scheduleConfiguration);

        /**
         * <p>
         * The schedule configuration settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateProgramScheduleConfiguration.Builder} avoiding the need to create one manually via
         * {@link UpdateProgramScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateProgramScheduleConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #scheduleConfiguration(UpdateProgramScheduleConfiguration)}.
         * 
         * @param scheduleConfiguration
         *        a consumer that will call methods on {@link UpdateProgramScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfiguration(UpdateProgramScheduleConfiguration)
         */
        default Builder scheduleConfiguration(Consumer<UpdateProgramScheduleConfiguration.Builder> scheduleConfiguration) {
            return scheduleConfiguration(UpdateProgramScheduleConfiguration.builder().applyMutation(scheduleConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private List<AdBreak> adBreaks = DefaultSdkAutoConstructList.getInstance();

        private String channelName;

        private String programName;

        private UpdateProgramScheduleConfiguration scheduleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProgramRequest model) {
            super(model);
            adBreaks(model.adBreaks);
            channelName(model.channelName);
            programName(model.programName);
            scheduleConfiguration(model.scheduleConfiguration);
        }

        public final List<AdBreak.Builder> getAdBreaks() {
            List<AdBreak.Builder> result = ___listOfAdBreakCopier.copyToBuilder(this.adBreaks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdBreaks(Collection<AdBreak.BuilderImpl> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copyFromBuilder(adBreaks);
        }

        @Override
        public final Builder adBreaks(Collection<AdBreak> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copy(adBreaks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(AdBreak... adBreaks) {
            adBreaks(Arrays.asList(adBreaks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(Consumer<AdBreak.Builder>... adBreaks) {
            adBreaks(Stream.of(adBreaks).map(c -> AdBreak.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getProgramName() {
            return programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final UpdateProgramScheduleConfiguration.Builder getScheduleConfiguration() {
            return scheduleConfiguration != null ? scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(UpdateProgramScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(UpdateProgramScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProgramRequest build() {
            return new UpdateProgramRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
