/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelResponse extends MediaTailorResponse implements
        ToCopyableBuilder<CreateChannelResponse.Builder, CreateChannelResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateChannelResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(CreateChannelResponse::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> CHANNEL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelState").getter(getter(CreateChannelResponse::channelStateAsString))
            .setter(setter(Builder::channelState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelState").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(CreateChannelResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<SlateSource> FILLER_SLATE_FIELD = SdkField.<SlateSource> builder(MarshallingType.SDK_POJO)
            .memberName("FillerSlate").getter(getter(CreateChannelResponse::fillerSlate)).setter(setter(Builder::fillerSlate))
            .constructor(SlateSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FillerSlate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(CreateChannelResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<List<ResponseOutputItem>> OUTPUTS_FIELD = SdkField
            .<List<ResponseOutputItem>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(CreateChannelResponse::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResponseOutputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResponseOutputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLAYBACK_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaybackMode").getter(getter(CreateChannelResponse::playbackMode)).setter(setter(Builder::playbackMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackMode").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateChannelResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(CreateChannelResponse::tier)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_NAME_FIELD,
            CHANNEL_STATE_FIELD, CREATION_TIME_FIELD, FILLER_SLATE_FIELD, LAST_MODIFIED_TIME_FIELD, OUTPUTS_FIELD,
            PLAYBACK_MODE_FIELD, TAGS_FIELD, TIER_FIELD));

    private final String arn;

    private final String channelName;

    private final String channelState;

    private final Instant creationTime;

    private final SlateSource fillerSlate;

    private final Instant lastModifiedTime;

    private final List<ResponseOutputItem> outputs;

    private final String playbackMode;

    private final Map<String, String> tags;

    private final String tier;

    private CreateChannelResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.channelState = builder.channelState;
        this.creationTime = builder.creationTime;
        this.fillerSlate = builder.fillerSlate;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.outputs = builder.outputs;
        this.playbackMode = builder.playbackMode;
        this.tags = builder.tags;
        this.tier = builder.tier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) to assign to the channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) to assign to the channel.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name to assign to the channel.
     * </p>
     * 
     * @return The name to assign to the channel.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * Indicates whether the channel is in a running state or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelState} will
     * return {@link ChannelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelStateAsString}.
     * </p>
     * 
     * @return Indicates whether the channel is in a running state or not.
     * @see ChannelState
     */
    public final ChannelState channelState() {
        return ChannelState.fromValue(channelState);
    }

    /**
     * <p>
     * Indicates whether the channel is in a running state or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelState} will
     * return {@link ChannelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelStateAsString}.
     * </p>
     * 
     * @return Indicates whether the channel is in a running state or not.
     * @see ChannelState
     */
    public final String channelStateAsString() {
        return channelState;
    }

    /**
     * <p>
     * The timestamp of when the channel was created.
     * </p>
     * 
     * @return The timestamp of when the channel was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Contains information about the slate used to fill gaps between programs in the schedule.
     * </p>
     * 
     * @return Contains information about the slate used to fill gaps between programs in the schedule.
     */
    public final SlateSource fillerSlate() {
        return fillerSlate;
    }

    /**
     * <p>
     * The timestamp of when the channel was last modified.
     * </p>
     * 
     * @return The timestamp of when the channel was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The output properties to assign to the channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The output properties to assign to the channel.
     */
    public final List<ResponseOutputItem> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The playback mode to assign to the channel.
     * </p>
     * 
     * @return The playback mode to assign to the channel.
     */
    public final String playbackMode() {
        return playbackMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon resources to help
     * with organization, access control, and cost tracking. For more information, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     * Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon resources
     *         to help with organization, access control, and cost tracking. For more information, see <a
     *         href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     *         Resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The tier of the channel.
     * </p>
     * 
     * @return The tier of the channel.
     */
    public final String tier() {
        return tier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(channelStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(fillerSlate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(playbackMode());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelResponse)) {
            return false;
        }
        CreateChannelResponse other = (CreateChannelResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(channelStateAsString(), other.channelStateAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(fillerSlate(), other.fillerSlate())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(playbackMode(), other.playbackMode())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && Objects.equals(tier(), other.tier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelResponse").add("Arn", arn()).add("ChannelName", channelName())
                .add("ChannelState", channelStateAsString()).add("CreationTime", creationTime())
                .add("FillerSlate", fillerSlate()).add("LastModifiedTime", lastModifiedTime())
                .add("Outputs", hasOutputs() ? outputs() : null).add("PlaybackMode", playbackMode())
                .add("Tags", hasTags() ? tags() : null).add("Tier", tier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "ChannelState":
            return Optional.ofNullable(clazz.cast(channelStateAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FillerSlate":
            return Optional.ofNullable(clazz.cast(fillerSlate()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "PlaybackMode":
            return Optional.ofNullable(clazz.cast(playbackMode()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelResponse, T> g) {
        return obj -> g.apply((CreateChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) to assign to the channel.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) to assign to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name to assign to the channel.
         * </p>
         * 
         * @param channelName
         *        The name to assign to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * Indicates whether the channel is in a running state or not.
         * </p>
         * 
         * @param channelState
         *        Indicates whether the channel is in a running state or not.
         * @see ChannelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelState
         */
        Builder channelState(String channelState);

        /**
         * <p>
         * Indicates whether the channel is in a running state or not.
         * </p>
         * 
         * @param channelState
         *        Indicates whether the channel is in a running state or not.
         * @see ChannelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelState
         */
        Builder channelState(ChannelState channelState);

        /**
         * <p>
         * The timestamp of when the channel was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp of when the channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Contains information about the slate used to fill gaps between programs in the schedule.
         * </p>
         * 
         * @param fillerSlate
         *        Contains information about the slate used to fill gaps between programs in the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fillerSlate(SlateSource fillerSlate);

        /**
         * <p>
         * Contains information about the slate used to fill gaps between programs in the schedule.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlateSource.Builder} avoiding the need to
         * create one manually via {@link SlateSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlateSource.Builder#build()} is called immediately and its result
         * is passed to {@link #fillerSlate(SlateSource)}.
         * 
         * @param fillerSlate
         *        a consumer that will call methods on {@link SlateSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fillerSlate(SlateSource)
         */
        default Builder fillerSlate(Consumer<SlateSource.Builder> fillerSlate) {
            return fillerSlate(SlateSource.builder().applyMutation(fillerSlate).build());
        }

        /**
         * <p>
         * The timestamp of when the channel was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp of when the channel was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The output properties to assign to the channel.
         * </p>
         * 
         * @param outputs
         *        The output properties to assign to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<ResponseOutputItem> outputs);

        /**
         * <p>
         * The output properties to assign to the channel.
         * </p>
         * 
         * @param outputs
         *        The output properties to assign to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(ResponseOutputItem... outputs);

        /**
         * <p>
         * The output properties to assign to the channel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.ResponseOutputItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mediatailor.model.ResponseOutputItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.ResponseOutputItem.Builder#build()} is called
         * immediately and its result is passed to {@link #outputs(List<ResponseOutputItem>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.ResponseOutputItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<ResponseOutputItem>)
         */
        Builder outputs(Consumer<ResponseOutputItem.Builder>... outputs);

        /**
         * <p>
         * The playback mode to assign to the channel.
         * </p>
         * 
         * @param playbackMode
         *        The playback mode to assign to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackMode(String playbackMode);

        /**
         * <p>
         * The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon resources to
         * help with organization, access control, and cost tracking. For more information, see <a
         * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon
         *        resources to help with organization, access control, and cost tracking. For more information, see <a
         *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental
         *        MediaTailor Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The tier of the channel.
         * </p>
         * 
         * @param tier
         *        The tier of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tier(String tier);
    }

    static final class BuilderImpl extends MediaTailorResponse.BuilderImpl implements Builder {
        private String arn;

        private String channelName;

        private String channelState;

        private Instant creationTime;

        private SlateSource fillerSlate;

        private Instant lastModifiedTime;

        private List<ResponseOutputItem> outputs = DefaultSdkAutoConstructList.getInstance();

        private String playbackMode;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelResponse model) {
            super(model);
            arn(model.arn);
            channelName(model.channelName);
            channelState(model.channelState);
            creationTime(model.creationTime);
            fillerSlate(model.fillerSlate);
            lastModifiedTime(model.lastModifiedTime);
            outputs(model.outputs);
            playbackMode(model.playbackMode);
            tags(model.tags);
            tier(model.tier);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelState() {
            return channelState;
        }

        public final void setChannelState(String channelState) {
            this.channelState = channelState;
        }

        @Override
        public final Builder channelState(String channelState) {
            this.channelState = channelState;
            return this;
        }

        @Override
        public final Builder channelState(ChannelState channelState) {
            this.channelState(channelState == null ? null : channelState.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final SlateSource.Builder getFillerSlate() {
            return fillerSlate != null ? fillerSlate.toBuilder() : null;
        }

        public final void setFillerSlate(SlateSource.BuilderImpl fillerSlate) {
            this.fillerSlate = fillerSlate != null ? fillerSlate.build() : null;
        }

        @Override
        public final Builder fillerSlate(SlateSource fillerSlate) {
            this.fillerSlate = fillerSlate;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final List<ResponseOutputItem.Builder> getOutputs() {
            List<ResponseOutputItem.Builder> result = ResponseOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<ResponseOutputItem.BuilderImpl> outputs) {
            this.outputs = ResponseOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<ResponseOutputItem> outputs) {
            this.outputs = ResponseOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(ResponseOutputItem... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<ResponseOutputItem.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> ResponseOutputItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPlaybackMode() {
            return playbackMode;
        }

        public final void setPlaybackMode(String playbackMode) {
            this.playbackMode = playbackMode;
        }

        @Override
        public final Builder playbackMode(String playbackMode) {
            this.playbackMode = playbackMode;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public CreateChannelResponse build() {
            return new CreateChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
